/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class LineBreakReplacer {
    private final String content;
    private final int contentLength;
    private final char replacementCharacter;
    private final String replacementCharacterAsString;
    private StringBuilder resultBuilder = null;

    private LineBreakReplacer(@Nullable String content, char replacementCharacter) {
        this.content = content != null ? content : "";
        this.contentLength = this.content.length();
        this.replacementCharacter = replacementCharacter;
        this.replacementCharacterAsString = String.valueOf(replacementCharacter);
    }

    private @NonNull String executeReplacement() {
        if (this.content.isEmpty()) {
            return this.content;
        }
        int lastReplacement = 0;
        block4: for (int currentPosition = 0; currentPosition < this.contentLength; ++currentPosition) {
            char c = this.content.charAt(currentPosition);
            switch (c) {
                case '\r': {
                    if (this.peek(currentPosition + 1) == '\n') {
                        this.getResultBuilder().append(this.content, lastReplacement, currentPosition).append(this.replacementCharacterAsString);
                        lastReplacement = currentPosition + 2;
                        ++currentPosition;
                        continue block4;
                    }
                }
                case '\n': 
                case '\u0085': {
                    if (c == this.replacementCharacter) continue block4;
                    this.getResultBuilder().append(this.content, lastReplacement, currentPosition).append(this.replacementCharacterAsString);
                    lastReplacement = currentPosition + 1;
                }
            }
        }
        if (this.resultBuilder != null) {
            this.resultBuilder.append(this.content, lastReplacement, this.contentLength);
            return this.resultBuilder.toString();
        }
        return this.content;
    }

    private char peek(int offset) {
        if (offset < this.contentLength) {
            return this.content.charAt(offset);
        }
        return '\u0000';
    }

    public static @NonNull String replaceLineBreaks(@Nullable String content, char replacementCharacter) {
        return new LineBreakReplacer(content, replacementCharacter).executeReplacement();
    }

    private StringBuilder getResultBuilder() {
        if (this.resultBuilder == null) {
            this.resultBuilder = new StringBuilder(this.content.length());
        }
        return this.resultBuilder;
    }
}

