/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.tree;

import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;

public class Trie<V> {
    private final TrieNode<V> root = new TrieNode<Object>(null, '\u0000', null);

    public void put(String key, @Nullable V value) {
        if (key == null || key.isEmpty()) {
            this.root.value = value;
            return;
        }
        TrieNode current = this.root;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            TrieNode parent = current;
            current = current.children.computeIfAbsent(Character.valueOf(c), k -> new TrieNode<Object>(parent, c, null));
        }
        current.value = value;
    }

    public @Nullable V get(String key) {
        TrieNode<V> node = this.getNode(key);
        if (node == null) {
            return null;
        }
        return node.value;
    }

    public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    public List<V> getValuesWithPrefix(String prefix) {
        TrieNode<V> node = this.getNode(prefix);
        if (node == null) {
            return Collections.emptyList();
        }
        ArrayList values = new ArrayList();
        this.collectValues(node, values);
        return values;
    }

    public <R> R aggregateValuesWithPrefix(String prefix, Function<Stream<V>, R> aggregationFunc) {
        return aggregationFunc.apply(this.streamValuesWithPrefix(prefix).map(Map.Entry::getValue));
    }

    public Stream<Map.Entry<String, V>> streamValuesWithPrefix(String prefix) {
        TrieNode<V> node = this.getNode(prefix);
        if (node == null) {
            return Stream.empty();
        }
        return this.streamEntriesFromNode(node);
    }

    private @Nullable TrieNode<V> getNode(String key) {
        if (key == null || key.isEmpty()) {
            return this.root;
        }
        TrieNode current = this.root;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            current = (TrieNode)current.children.get(Character.valueOf(c));
            if (current != null) continue;
            return null;
        }
        return current;
    }

    private void collectValues(TrieNode<V> node, List<V> values) {
        if (node.value != null) {
            values.add(node.value);
        }
        for (TrieNode child : node.children.values()) {
            this.collectValues(child, values);
        }
    }

    private Stream<Map.Entry<String, V>> streamEntriesFromNode(final TrieNode<V> node) {
        Iterator iterator = new Iterator<Map.Entry<String, V>>(this){
            private final Deque<TrieNode<V>> stack = new ArrayDeque();
            private Map.Entry<String, V> nextEntry;
            {
                this.stack.push(node);
                this.advance();
            }

            private void advance() {
                this.nextEntry = null;
                while (!this.stack.isEmpty()) {
                    TrieNode current = this.stack.pop();
                    for (TrieNode child : current.children.values()) {
                        this.stack.push(child);
                    }
                    if (current.value == null) continue;
                    String fullKey = current.getFullKey();
                    this.nextEntry = new AbstractMap.SimpleEntry(fullKey, current.value);
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                return this.nextEntry != null;
            }

            @Override
            public Map.Entry<String, V> next() {
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
                Map.Entry result = this.nextEntry;
                this.advance();
                return result;
            }
        };
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 1280);
        return StreamSupport.stream(spliterator, false);
    }

    public @Nullable V getValueOnLongestPrefix(String sequence) {
        char c;
        TrieNode next;
        if (sequence == null || sequence.isEmpty()) {
            return this.root.value;
        }
        TrieNode current = this.root;
        Object lastFoundValue = this.root.value;
        for (int i = 0; i < sequence.length() && (next = (TrieNode)current.children.get(Character.valueOf(c = sequence.charAt(i)))) != null; ++i) {
            current = next;
            if (current.value == null) continue;
            lastFoundValue = current.value;
        }
        return lastFoundValue;
    }

    private static class TrieNode<V> {
        private final ConcurrentMap<Character, TrieNode<V>> children = new ConcurrentHashMap<Character, TrieNode<V>>();
        private volatile @Nullable V value;
        private final @Nullable TrieNode<V> parent;
        private final char keyChar;
        private volatile String fullKey;

        TrieNode(@Nullable TrieNode<V> parent, char keyChar, @Nullable V value) {
            this.parent = parent;
            this.keyChar = keyChar;
            this.value = value;
            this.fullKey = null;
        }

        public String getFullKey() {
            if (this.fullKey != null) {
                return this.fullKey;
            }
            StringBuilder sb = new StringBuilder();
            this.buildFullKey(this, sb);
            this.fullKey = sb.toString();
            return this.fullKey;
        }

        private void buildFullKey(TrieNode<V> node, StringBuilder sb) {
            if (node.parent != null) {
                this.buildFullKey(node.parent, sb);
                if (node.keyChar != '\u0000') {
                    sb.append(node.keyChar);
                }
            }
        }
    }
}

