/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import us.hebi.matlab.mat.format.CharEncoding;
import us.hebi.matlab.mat.types.MatlabType;
import us.hebi.matlab.mat.types.Sink;
import us.hebi.matlab.mat.util.Casts;

public enum Mat5Type {
    Int8(1),
    UInt8(2),
    Int16(3),
    UInt16(4),
    Int32(5),
    UInt32(6),
    Single(7),
    Double(9),
    Int64(12),
    UInt64(13),
    Matrix(14),
    Compressed(15),
    Utf8(16),
    Utf16(17),
    Utf32(18);

    private final int id;
    private static final Mat5Type[] lookup;
    private static final byte[] paddingBuffer;

    void writeByteBufferWithTag(ByteBuffer buffer, Sink sink) throws IOException {
        if (this.bytes() > 1 && buffer.order() != sink.order()) {
            throw new IllegalArgumentException("Buffer order does not match sink order");
        }
        int position = buffer.position();
        int numElements = buffer.remaining() / this.bytes();
        this.writeTag(numElements, sink);
        sink.writeByteBuffer(buffer);
        this.writePadding(numElements, sink);
        buffer.position(position);
    }

    void writeBytesWithTag(byte[] values, Sink sink) throws IOException {
        if (this.bytes() != 1) {
            throw new IllegalArgumentException("Not a byte tag type");
        }
        this.writeTag(values.length, sink);
        sink.writeBytes(values, 0, values.length);
        this.writePadding(values.length, sink);
    }

    void writeIntsWithTag(int[] values, Sink sink) throws IOException {
        if (this != Int32 && this != UInt32) {
            throw new IllegalArgumentException("Not an integer tag type");
        }
        this.writeTag(values.length, sink);
        sink.writeInts(values, 0, values.length);
        this.writePadding(values.length, sink);
    }

    public int computeSerializedSize(int numElements) {
        int numBytes = this.getNumBytes(numElements);
        boolean packed = Mat5Type.isPackable(numBytes);
        int tagSize = packed ? 4 : 8;
        int padding = this.getPadding(numBytes, packed);
        return tagSize + numBytes + padding;
    }

    public void writeTag(int numElements, boolean allowPacking, Sink sink) throws IOException {
        int numBytes = this.getNumBytes(numElements);
        if (allowPacking && Mat5Type.isPackable(numBytes)) {
            sink.writeInt(numBytes << 16 | this.id());
        } else {
            sink.writeInt(this.id());
            sink.writeInt(numBytes);
        }
    }

    public void writeTag(int numElements, Sink sink) throws IOException {
        this.writeTag(numElements, true, sink);
    }

    public void writePadding(int numElements, Sink sink) throws IOException {
        int numBytes = this.getNumBytes(numElements);
        int padding = this.getPadding(numBytes, Mat5Type.isPackable(numBytes));
        if (padding == 0) {
            return;
        }
        sink.writeBytes(paddingBuffer, 0, padding);
    }

    int getPadding(int numBytes, boolean packed) {
        switch (this) {
            case Matrix: 
            case Compressed: {
                return 0;
            }
        }
        int tagSize = packed ? 4 : 8;
        int padding = (tagSize + numBytes) % 8;
        return padding == 0 ? 0 : 8 - padding;
    }

    private int getNumBytes(long numElements) {
        return Casts.sint32((long)this.bytes() * numElements);
    }

    private static boolean isPackable(int numBytes) {
        return numBytes <= 4;
    }

    public int bytes() {
        switch (this) {
            case Int8: 
            case UInt8: {
                return 1;
            }
            case Int16: 
            case UInt16: {
                return 2;
            }
            case Int32: 
            case UInt32: 
            case Single: {
                return 4;
            }
            case Int64: 
            case UInt64: 
            case Double: {
                return 8;
            }
        }
        return 1;
    }

    public static Mat5Type fromNumericalType(MatlabType type) {
        switch (type) {
            case Int8: {
                return Int8;
            }
            case Int16: {
                return Int16;
            }
            case Int32: {
                return Int32;
            }
            case Int64: {
                return Int64;
            }
            case UInt8: {
                return UInt8;
            }
            case UInt16: {
                return UInt16;
            }
            case UInt32: {
                return UInt32;
            }
            case UInt64: {
                return UInt64;
            }
            case Single: {
                return Single;
            }
            case Double: {
                return Double;
            }
        }
        throw new IllegalArgumentException("Not a numerical type: " + (Object)((Object)type));
    }

    public CharEncoding getCharEncoding() {
        switch (this) {
            case Utf8: {
                return CharEncoding.Utf8;
            }
            case Utf16: {
                return CharEncoding.Utf16;
            }
            case Utf32: {
                return CharEncoding.Utf32;
            }
            case UInt16: {
                return CharEncoding.UInt16;
            }
        }
        throw new IllegalArgumentException("Not a character type: " + (Object)((Object)this));
    }

    public static Mat5Type fromCharEncoding(CharEncoding type) {
        switch (type) {
            case Utf8: {
                return Utf8;
            }
            case Utf16: {
                return Utf16;
            }
            case Utf32: {
                return Utf32;
            }
            case UInt16: {
                return UInt16;
            }
        }
        throw new IllegalArgumentException("Unknown char type " + (Object)((Object)type));
    }

    public static Mat5Type fromId(int id) {
        Mat5Type type;
        if (id > 0 && id < lookup.length && (type = lookup[id]) != null) {
            return type;
        }
        throw new IllegalArgumentException("Unknown tag type for id: " + id);
    }

    public int id() {
        return this.id;
    }

    private Mat5Type(int id) {
        this.id = id;
    }

    static {
        int highestId = 0;
        for (Mat5Type type : Mat5Type.values()) {
            highestId = Math.max(highestId, type.id);
        }
        lookup = new Mat5Type[highestId + 1];
        Mat5Type[] mat5TypeArray = Mat5Type.values();
        int n = mat5TypeArray.length;
        for (int i = 0; i < n; ++i) {
            Mat5Type type;
            Mat5Type.lookup[type.id()] = type = mat5TypeArray[i];
        }
        paddingBuffer = new byte[8];
    }
}

