/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.util;

import us.hebi.matlab.mat.util.ArrayBoundsCheck;
import us.hebi.matlab.mat.util.ByteConverter;
import us.hebi.matlab.mat.util.HeapByteConverter;
import us.hebi.matlab.mat.util.UnsafeAccess;
import us.hebi.matlab.mat.util.UnsafeByteConverter;

public class ByteConverters {
    private static final ByteConverter heapConverter = new HeapByteConverter();
    private static final ByteConverter rawUnsafeConverter;
    private static final ByteConverter unsafeConverterWithBoundsCheck;

    public static ByteConverter getSafest() {
        return heapConverter;
    }

    public static ByteConverter getFastest() {
        return ByteConverters.getFastest(true);
    }

    public static ByteConverter getFastest(boolean checkBounds) {
        if (UnsafeAccess.isAvailable() && UnsafeAccess.allowUnalignedAccess()) {
            return checkBounds ? unsafeConverterWithBoundsCheck : rawUnsafeConverter;
        }
        return heapConverter;
    }

    static {
        if (UnsafeAccess.isAvailable() && UnsafeAccess.allowUnalignedAccess()) {
            UnsafeByteConverter unsafeConverter = new UnsafeByteConverter();
            rawUnsafeConverter = unsafeConverter;
            unsafeConverterWithBoundsCheck = new ArrayBoundsCheck(unsafeConverter);
        } else {
            rawUnsafeConverter = null;
            unsafeConverterWithBoundsCheck = null;
        }
    }
}

