/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.config;

import com.teamscale.core.options.InstanceLabelOption;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/instance-label")
public class InstanceLabelService
extends ApiBase {
    @GET
    @Operation(summary="Get instance label", description="Allows to retrieve the server's instance label, as set in the admin settings.", tags={"System"})
    @Produces(value={"text/plain"})
    @RequiresNoLogin
    public String getInstanceLabel() {
        try {
            return InstanceLabelOption.getLabel((GlobalStorageSystem)this.getGlobalStorageSystem());
        }
        catch (StorageException e) {
            throw new InternalServerErrorException("Could not retrieve the instance label from the database: " + e.getMessage(), (Throwable)e);
        }
    }
}

