/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.architecture.ArchitectureAssessmentIndex;
import com.teamscale.index.architecture.ArchitectureAssessmentInfo;
import com.teamscale.index.architecture.ArchitectureComponentInfo;
import com.teamscale.index.architecture.ITypeToFileLookup;
import com.teamscale.index.architecture.external.ArchitectureUploadAnalysisStateIndex;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.service.architecture.ArchitectureAssessmentUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.parameter.ResolveToCodePath;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/architectures/components")
public class ArchitectureComponentAssignmentService
extends ApiBase {
    private static final String EXCLUDED_FROM_ARCHITECTURE = "Excluded from architecture";
    private static final String NOT_MATCHED_IN_ARCHITECTURE = "No matched component";

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get architecture components", description="Returns the list of architecture component assignments for an element in all the available project architectures.", tags={"Architecture"})
    public List<ArchitectureComponentAssignment> getArchitectureComponentAssignments(@QueryParam(value="uniform-path") @DefaultValue(value="") @ResolveToCodePath UniformPath uniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        ArchitectureAssessmentIndex architectureAssessmentIndex = this.openProjectIndex(ArchitectureAssessmentIndex.class, historyOption);
        return this.retrieveArchitectureComponentAssignments(uniformPath.toString(), architectureAssessmentIndex, historyOption);
    }

    private List<ArchitectureComponentAssignment> retrieveArchitectureComponentAssignments(String fileUniformPath, ArchitectureAssessmentIndex architectureAssessmentIndex, HistoryAccessOption historyOption) throws StorageException {
        TokenElementIndex contentIndex = this.openProjectIndex(TokenElementIndex.class, "content", historyOption);
        Set<String> allArchitecturePaths = this.getAllArchitecturePaths(architectureAssessmentIndex, historyOption);
        ArrayList<ArchitectureComponentAssignment> componentAssignments = new ArrayList<ArchitectureComponentAssignment>();
        SupplierWithException typeFileLookupMap = SupplierWithException.memoize(() -> this.openProjectIndex(TypeIndex.class, historyOption).getTypeFileLookupMap());
        for (String architecturePath : allArchitecturePaths) {
            ArchitectureAssessmentInfo assessment = ArchitectureAssessmentUtils.getAssessmentInfo(architecturePath, architectureAssessmentIndex);
            ArchitectureDefinition architecture = ArchitectureAssessmentUtils.getArchitectureDefinition(architecturePath, contentIndex);
            Objects.requireNonNull(architecture, () -> "No architecture definition found for path: %s".formatted(architecturePath));
            if (assessment.fileBased) {
                componentAssignments.add(ArchitectureComponentAssignmentService.getFileBasedAssignments(architecture, assessment, fileUniformPath, architecturePath));
                continue;
            }
            componentAssignments.add(ArchitectureComponentAssignmentService.getTypeBasedAssignments(architecture, assessment, fileUniformPath, architecturePath, ITypeToFileLookup.create((ArchitectureDefinition)architecture, (ListMap)((ListMap)typeFileLookupMap.get()))));
        }
        return componentAssignments;
    }

    private static ArchitectureComponentAssignment getFileBasedAssignments(ArchitectureDefinition architecture, ArchitectureAssessmentInfo assessment, String fileUniformPath, String archPath) {
        List allComponentsInfo = assessment.getRoot().getSubComponentsRecursively();
        if (Pattern.compile(architecture.getScopeExcludePattern()).matcher(fileUniformPath).matches()) {
            return new ArchitectureComponentAssignment(archPath, EXCLUDED_FROM_ARCHITECTURE, 2);
        }
        if (assessment.getOrphans().contains(fileUniformPath)) {
            return new ArchitectureComponentAssignment(archPath, NOT_MATCHED_IN_ARCHITECTURE, 1);
        }
        for (ArchitectureComponentInfo componentInfo : allComponentsInfo) {
            if (!componentInfo.getMatchedTypes().containsKey((Object)fileUniformPath)) continue;
            return new ArchitectureComponentAssignment(archPath, componentInfo.name, 0);
        }
        return new ArchitectureComponentAssignment(archPath, EXCLUDED_FROM_ARCHITECTURE, 2);
    }

    private static ArchitectureComponentAssignment getTypeBasedAssignments(ArchitectureDefinition architecture, ArchitectureAssessmentInfo assessment, String fileUniformPath, String archPath, ITypeToFileLookup typeToFileLookup) {
        List allComponentsInfo = assessment.getRoot().getSubComponentsRecursively();
        if (Pattern.compile(architecture.getScopeExcludePattern()).matcher(fileUniformPath).matches()) {
            return new ArchitectureComponentAssignment(archPath, EXCLUDED_FROM_ARCHITECTURE, 2);
        }
        boolean isOrphan = assessment.getOrphans().stream().anyMatch(orphanType -> typeToFileLookup.getFilesForType(orphanType).contains(fileUniformPath));
        if (isOrphan) {
            return new ArchitectureComponentAssignment(archPath, NOT_MATCHED_IN_ARCHITECTURE, 1);
        }
        for (ArchitectureComponentInfo componentInfo : allComponentsInfo) {
            UnmodifiableCollection matchedFiles = componentInfo.getMatchedTypes().values();
            if (!matchedFiles.contains(fileUniformPath)) continue;
            return new ArchitectureComponentAssignment(archPath, componentInfo.name, 0);
        }
        return new ArchitectureComponentAssignment(archPath, EXCLUDED_FROM_ARCHITECTURE, 2);
    }

    private Set<String> getAllArchitecturePaths(ArchitectureAssessmentIndex architectureAssessmentIndex, HistoryAccessOption historyOption) throws StorageException {
        Map<String, ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType> uploadsInProgress = ArchitectureAssessmentUtils.getUploadsInProgress((ProjectStorageSystem)this.getProjectStorageSystem(), historyOption);
        HashSet existingArchitectures = new HashSet(architectureAssessmentIndex.getAllAssessmentUniformPaths());
        return CollectionUtils.unionSet(existingArchitectures, (Collection[])new Collection[]{uploadsInProgress.keySet()});
    }

    public static class ArchitectureComponentAssignment {
        private static final String ARCHITECTURE_PATH_PROPERTY = "architecturePath";
        private static final String SORT_KEY_PROPERTY = "sortKey";
        private static final String COMPONENT_NAME_PROPERTY = "componentName";
        @JsonProperty(value="componentName")
        private final String componentName;
        @JsonProperty(value="architecturePath")
        private final String architecturePath;
        @JsonProperty(value="sortKey")
        private final int sortKey;

        @JsonCreator
        public ArchitectureComponentAssignment(@JsonProperty(value="architecturePath") String architecturePath, @JsonProperty(value="componentName") String componentName, @JsonProperty(value="sortKey") int sortKey) {
            this.architecturePath = architecturePath;
            this.componentName = componentName;
            this.sortKey = sortKey;
        }

        public String getComponentName() {
            return this.componentName;
        }
    }
}

