/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricDirectoryIndex;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.index.audit.checks.CustomExceptionDefinitionCheck;
import com.teamscale.index.audit.checks.ThrowSpecificExceptionsJavaCheck;
import com.teamscale.index.tracking.index.TrackedFindingsIndex;
import eu.cqse.check.clike.CatchHighLevelExceptionCheck;
import eu.cqse.check.clike.CopyrightHeaderCommentCheck;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import jakarta.ws.rs.InternalServerErrorException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.math.MathUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jetbrains.annotations.VisibleForTesting;

public class ProjectDataAccessor {
    private static final String CLONE_LENGTH_PROPERTY_KEY = "Length";
    private static final double AVERAGE_DAYS_IN_MONTH = 30.416666666666668;
    private static final Set<String> NULL_POINTER_EXCEPTION_NAMES = CollectionUtils.unionSet((Collection)LanguageFeatureParser.JAVA.generateExceptionNamesSet(new Class[]{NullPointerException.class}), (Collection[])new Collection[]{Set.of("NullReferenceException")});
    private MetricDirectoryEntry metricDirectoryEntry;
    private TrackedFindingsIndex trackedFindingsIndex;
    private MetricDirectorySchema schema;
    private final PublicProjectId projectId;
    private List<TrackedFinding> allFindings = null;
    private List<TrackedFinding> allCloneFindings = null;
    private List<Long> taskAges = null;

    public ProjectDataAccessor(ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyOption, PublicProjectId projectId, UniformPath uniformPath) throws StorageException {
        this.projectId = projectId;
        this.initializeAccessor(projectStorageSystem, historyOption, uniformPath);
    }

    private void initializeAccessor(ProjectStorageSystem projectStorageSystem, HistoryAccessOption historyOption, UniformPath uniformPath) throws StorageException {
        MetricDirectoryIndex metricDirectoryIndex = (MetricDirectoryIndex)projectStorageSystem.openProjectIndex(MetricDirectoryIndex.class, "metrics-dir", historyOption);
        HistoryAccessOption defaultBranchHistoryOption = HistoryAccessOption.readTimestampUnbranched((long)historyOption.getTimestamp());
        MetricSchemaIndex metricSchemaIndex = (MetricSchemaIndex)projectStorageSystem.openProjectIndex(MetricSchemaIndex.class, "metric-schema", defaultBranchHistoryOption);
        this.metricDirectoryEntry = metricDirectoryIndex.getMetricDirectoryEntry(uniformPath.toString());
        this.schema = metricSchemaIndex.getPublicSchema();
        this.trackedFindingsIndex = (TrackedFindingsIndex)projectStorageSystem.openProjectIndex(TrackedFindingsIndex.class, historyOption);
    }

    public PublicProjectId getProjectId() {
        return this.projectId;
    }

    public boolean metricSchemaHasValue(String metric) {
        return this.schema.getValuePosition(metric) >= 0;
    }

    public Object getMetricValue(String metric) {
        if (this.metricDirectoryEntry == null) {
            throw new InternalServerErrorException("No metrics available for project");
        }
        int valuePosition = this.schema.getValuePosition(metric);
        CCSMAssert.isFalse((valuePosition == -1 ? 1 : 0) != 0, (String)("No value position found for analysis " + metric));
        return this.metricDirectoryEntry.getValue(valuePosition);
    }

    private static Integer getNumericFindingProperty(String propertyKey, IndexFinding finding) {
        Object propertyObject = finding.getProperties().get(propertyKey);
        if (propertyObject instanceof Integer) {
            return (Integer)propertyObject;
        }
        CCSMAssert.fail((String)("Finding doesn't have a '" + propertyKey + "' numeric property: " + String.valueOf(finding)));
        return null;
    }

    private Stream<TrackedFinding> getStreamOfAllFindings() throws StorageException {
        if (this.allFindings == null) {
            this.allFindings = this.trackedFindingsIndex.getAllEntries().extractSecondList().stream().flatMap(Collection::stream).collect(Collectors.toList());
        }
        return this.allFindings.stream();
    }

    private long countFindingForCritera(Predicate<IndexFinding> predicate) throws StorageException {
        return this.getStreamOfAllFindings().filter(predicate).count();
    }

    public Long getNumberOfClones() throws StorageException {
        return this.countFindingForCritera(ProjectDataAccessor::isCloneFinding);
    }

    public long getNumberOfEmptyCatchBlocks() throws StorageException {
        return this.countFindingForCritera(ProjectDataAccessor::isEmptyCatchBlockFinding);
    }

    private Integer maxMetricForCloneFindings(Function<IndexFinding, Integer> f) throws StorageException {
        if (this.allCloneFindings == null) {
            this.allCloneFindings = this.getStreamOfAllFindings().filter(ProjectDataAccessor::isCloneFinding).collect(Collectors.toList());
        }
        return this.allCloneFindings.stream().map(f).max(Integer::compare).orElse(Integer.MIN_VALUE);
    }

    public Integer getMostFrequentCloneMetric() throws StorageException {
        return this.maxMetricForCloneFindings(finding -> ProjectDataAccessor.getNumericFindingProperty("Instances", finding));
    }

    public Integer getLongestCloneMetric() throws StorageException {
        return this.maxMetricForCloneFindings(finding -> ProjectDataAccessor.getNumericFindingProperty(CLONE_LENGTH_PROPERTY_KEY, finding));
    }

    private static boolean isFindingInGroup(IndexFinding finding, String group) {
        return Objects.equals(finding.getGroupName(), group);
    }

    private static boolean isCloneFinding(IndexFinding finding) {
        return ProjectDataAccessor.isFindingInGroup(finding, "Code Clones");
    }

    @VisibleForTesting
    static boolean isEmptyCatchBlockFinding(IndexFinding finding) {
        return finding.getTypeId().endsWith("/cqse-empty-catch-block") && finding.getMessage().equals("Empty catch block");
    }

    private static boolean isFindingForCheck(IndexFinding finding, Class<? extends CheckImplementationBase> checkClass) {
        Check checkAnnotation = checkClass.getAnnotation(Check.class);
        return checkAnnotation != null && Objects.equals(finding.getProperties().get("Check"), checkAnnotation.name());
    }

    private static boolean isCustomExceptionFinding(IndexFinding finding) {
        return ProjectDataAccessor.isFindingForCheck(finding, CustomExceptionDefinitionCheck.class);
    }

    private static boolean isThrowOfHighLevelExceptionFinding(IndexFinding finding) {
        return ProjectDataAccessor.isFindingForCheck(finding, ThrowSpecificExceptionsJavaCheck.class);
    }

    private static boolean isCatchOfHighLevelExceptionFinding(IndexFinding finding) {
        return ProjectDataAccessor.isFindingForCheck(finding, CatchHighLevelExceptionCheck.class);
    }

    private static boolean isCatchOfNullPointerExceptionFinding(IndexFinding finding) {
        return NULL_POINTER_EXCEPTION_NAMES.stream().map(arg_0 -> ProjectDataAccessor.lambda$isCatchOfNullPointerExceptionFinding$2("Catch of `%s`", arg_0)).anyMatch(findingMessage -> findingMessage.equals(finding.getMessage()));
    }

    private static boolean isCopyrightCompletenessFinding(IndexFinding finding) {
        return ProjectDataAccessor.isFindingForCheck(finding, CopyrightHeaderCommentCheck.class);
    }

    private static boolean isTaskTagFinding(IndexFinding finding) {
        return ProjectDataAccessor.isFindingInGroup(finding, "Task Tags");
    }

    private long countFindingsForPredicate(Predicate<IndexFinding> predicate) throws StorageException {
        return this.getStreamOfAllFindings().filter(predicate).count();
    }

    private long countFilesWithFindingForPredicate(Predicate<IndexFinding> predicate) throws StorageException {
        return this.trackedFindingsIndex.getAllEntries().stream().filter(pair -> ((List)pair.getSecond()).stream().anyMatch(predicate)).count();
    }

    public long getNumberOfCustomExceptions() throws StorageException {
        return this.countFindingsForPredicate(ProjectDataAccessor::isCustomExceptionFinding);
    }

    public long getNumberOfFilesWithHighLevelCatch() throws StorageException {
        return this.countFilesWithFindingForPredicate(ProjectDataAccessor::isCatchOfHighLevelExceptionFinding);
    }

    public long getNumberOfFilesWithNullPointerExceptionCatch() throws StorageException {
        return this.countFilesWithFindingForPredicate(ProjectDataAccessor::isCatchOfNullPointerExceptionFinding);
    }

    public long getNumberOfFilesWithHighLevelThrows() throws StorageException {
        return this.countFilesWithFindingForPredicate(ProjectDataAccessor::isThrowOfHighLevelExceptionFinding);
    }

    public long getNumberOfCopyrightCompletenessFindings() throws StorageException {
        return this.countFindingsForPredicate(ProjectDataAccessor::isCopyrightCompletenessFinding);
    }

    public double getTaskAgeMedianByMonths() throws StorageException {
        return MathUtils.median(this.getTaskAgesInMonths());
    }

    public double getMeanTaskAgeByMonths() throws StorageException {
        return MathUtils.mean(this.getTaskAgesInMonths());
    }

    private List<Long> getTaskAgesInMonths() throws StorageException {
        if (this.taskAges == null) {
            this.taskAges = this.getStreamOfAllFindings().filter(ProjectDataAccessor::isTaskTagFinding).map(ProjectDataAccessor::getFindingAgeInMonths).collect(Collectors.toList());
        }
        return this.taskAges;
    }

    private static long getFindingAgeInMonths(TrackedFinding finding) {
        long creationTimestamp = finding.getBirthCommit().getTimestamp();
        long diffInMilliseconds = System.currentTimeMillis() - creationTimestamp;
        long diffInDays = TimeUnit.DAYS.convert(diffInMilliseconds, TimeUnit.MILLISECONDS);
        return Math.round((double)diffInDays / 30.416666666666668);
    }

    private static /* synthetic */ String lambda$isCatchOfNullPointerExceptionFinding$2(String rec$, Object xva$0) {
        return "Catch of `%s`".formatted(xva$0);
    }
}

