/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.commits;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/initial-commit-finder/{unresolvedCommit}")
public class InitialCommitFinderService
extends ApiBase {
    @GET
    @Operation(description="Returns the initial commit which added the file at the given path.")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @ApiResponse(responseCode="204", description="If there is no commit known for the given branch")
    public CommitDescriptor findInitialCommit(@PathParam(value="unresolvedCommit") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor unresolvedCommitDescriptor, @QueryParam(value="uniformPath") @Parameter(description="The path of the file") String uniformPath) throws StorageException {
        CommitDescriptorIndex commitDescriptorIndex = this.openProjectIndex(CommitDescriptorIndex.class, null);
        RepositoryLogFileIndex repositoryLogFileIndex = this.openProjectIndex(RepositoryLogFileIndex.class, null);
        CommitDescriptor commitDescriptor = UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)unresolvedCommitDescriptor, () -> this.getProjectStorageSystem());
        List commitsOnBranch = commitDescriptorIndex.getCommitsForBranch(commitDescriptor.getBranchName());
        if (uniformPath != null) {
            return repositoryLogFileIndex.getOldestCommitForPath(commitsOnBranch, uniformPath);
        }
        if (!commitsOnBranch.isEmpty()) {
            return (CommitDescriptor)commitsOnBranch.get(0);
        }
        return null;
    }
}

