/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.query.StoredQueryDescriptor;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.issues.IssueQueriesService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/issues/metrics")
public class IssueMetricsService {
    @Context
    private ResourceContext resourceContext;

    @POST
    @PublicApi(since=ETeamscaleVersion.VERSION_6_0_0, deprecatedSince=ETeamscaleVersion.VERSION_7_4_0)
    @Operation(summary="Save issue query", description="Creates an issue query descriptor in the system.", tags={"Issues", "Stored Queries"})
    @RequiresProjectPermission(value={EProjectPermission.EDIT_ISSUE_QUERIES})
    public void saveIssueQueryDescriptor(@RequestBody(required=true) StoredQueryDescriptor storedQueryDescriptor) throws StorageException {
        IssueQueriesService resource = (IssueQueriesService)this.resourceContext.getResource(IssueQueriesService.class);
        resource.saveIssueQueryDescriptor(storedQueryDescriptor);
    }
}

