/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.permissions;

import com.teamscale.core.permissions.PermissionLookup;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Set;

@Path(value="api/basic-permissions")
public class BasicPermissionService
extends ApiBase {
    @GET
    @RequiresNoPermission
    @Operation(summary="Get permission lookup", description="Returns a permission lookup for the whole permission scope", tags={"Permission"})
    public PermissionLookup<EBasicPermission> getPermissionLookup(@Parameter(description="Determines the basic permission scope for the instances. Represented by the enum values of EBasicPermissionScope.", required=true) @QueryParam(value="permission-scope") EBasicPermissionScope permissionScope) {
        return this.getPermissions().getPermissionLookup(permissionScope);
    }

    @GET
    @Path(value="{instanceId}")
    @RequiresNoPermission
    @Operation(summary="Get permissions for an instance", description="Returns a set of basic permissions for a single instance identified by the instance ID.", tags={"Permission"})
    public Set<EBasicPermission> getInstancePermissions(@Parameter(description="ID of the instance to get the permissions for", required=true) @PathParam(value="instanceId") String instanceId, @Parameter(description="Determines the basic permission scope for the instances. Represented by the enum values of EBasicPermissionScope.", required=true) @QueryParam(value="permission-scope") EBasicPermissionScope permissionScope) {
        return this.getPermissionLookup(permissionScope).getPermissions(instanceId);
    }
}

