/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.permissions;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.PermissionModifier;
import com.teamscale.core.permissions.PermissionUtils;
import com.teamscale.core.permissions.RoleChange;
import com.teamscale.core.permissions.RoleSchema;
import com.teamscale.core.permissions.RolesWithAssignments;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.permissions.roles.ProjectRole;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.HashSet;
import java.util.Map;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/roles/project-role-assignments")
public class ProjectRoleAssignmentsService
extends ApiBase {
    @GET
    @Path(value="{instance}")
    @RequiresNoPermission(description="Requires the permission to \"Assign Roles\" for the project")
    @Operation(summary="Get project roles with assignments", description="Returns the roles assigned to users or groups on an object.", tags={"Permission"})
    public RolesWithAssignments<ProjectRole> getProjectRolesWithAssignments(@Parameter(description="The project ID to load roles for.") @PathParam(value="instance") PublicProjectId instance) throws StorageException {
        PermissionIndex permissionIndex = this.openGlobalIndex(PermissionIndex.class);
        RoleSchema roleSchema = permissionIndex.getRoleSchema();
        ServicePermissions permissions = this.getPermissions();
        if (permissions.checkForExistingProject((IProjectId)instance)) {
            permissions.checkProjectPermission((IProjectId)instance, EProjectPermission.EDIT_ROLES);
        }
        return new RolesWithAssignments(roleSchema.getProjectRoles(), permissionIndex.getProjectRoles((IProjectId)instance));
    }

    @POST
    @Path(value="{instance}")
    @RequiresNoPermission(description="Requires the permission to \"Assign Roles\" for the project")
    @Operation(summary="Apply role change for the project's role assignments", description="Processes the post request and updates the role assignments according to the {@link RoleChange} for the given project.", tags={"Permission"})
    public void postRoleChangeForInstance(@RequestBody(required=true) Map<PublicProjectId, RoleChange> projectRoleChanges, @Parameter(description="The project ID to load roles for.") @PathParam(value="instance") PublicProjectId instance) throws StorageException {
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        ProjectInfo projectInfo = projectIndex.resolveProject((IProjectId)instance);
        HashSet publicProjectIds = new HashSet(projectInfo.getPublicIds());
        if (!publicProjectIds.containsAll(projectRoleChanges.keySet())) {
            throw new BadRequestException();
        }
        projectRoleChanges.values().forEach(PermissionUtils::checkRoleChange);
        PermissionModifier permissionModifier = this.getPermissions().createPermissionModifier();
        for (Map.Entry<PublicProjectId, RoleChange> entry : projectRoleChanges.entrySet()) {
            permissionModifier.changeProjectRoleAssignments((IProjectId)entry.getKey(), entry.getValue());
        }
    }

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_GLOBAL_ROLES})
    @Operation(summary="Apply role change for project role assignments globally", description="Processes the post request and updates the role assignments according to the {@link RoleChange} globally.", tags={"Permission"})
    public void postRoleChangeGlobally(@RequestBody(required=true) RoleChange roleChange) throws StorageException {
        PermissionUtils.checkRoleChange((RoleChange)roleChange);
        this.getPermissions().createPermissionModifier().changeProjectRoleAssignments(roleChange);
    }
}

