/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.precommit;

import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.index.precommit.PreCommitLimitsOption;
import com.teamscale.index.precommit.PreCommitUploadData;
import com.teamscale.index.precommit.PreCommitUserInfoIndex;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import org.conqat.engine.index.shared.PreCommit3Result;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

public class PreCommitLimitsChecker {
    public static List<PreCommit3Result.PreCommit3ErrorDetail> getLimitViolations(String currentUser, PublicProjectId project, PreCommitUploadData data, GlobalStorageSystem globalStorage) throws StorageException {
        if (data.isDeletionOnlyUpload()) {
            return Collections.emptyList();
        }
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)globalStorage.openGlobalIndex(ServerOptionIndex.class);
        PreCommitLimitsOption limits = (PreCommitLimitsOption)ServerOptionRegistry.getInstance().getServerOption("precommit.limit.options", PreCommitLimitsOption.class, serverOptionIndex);
        ArrayList<PreCommit3Result.PreCommit3ErrorDetail> limitViolationMessages = new ArrayList<PreCommit3Result.PreCommit3ErrorDetail>();
        PreCommitLimitsChecker.checkFileCountLimit(data, limits, limitViolationMessages);
        PreCommitLimitsChecker.checkFileSizeLimit(data, limits, limitViolationMessages);
        PreCommitUserInfoIndex userInfoIndex = (PreCommitUserInfoIndex)globalStorage.openGlobalIndex(PreCommitUserInfoIndex.class);
        PreCommitLimitsChecker.checkTimeLimit(limits, currentUser, project, userInfoIndex, limitViolationMessages);
        if (limitViolationMessages.isEmpty()) {
            userInfoIndex.setLastUpload(currentUser, project, DateTimeUtils.now().toEpochMilli());
        }
        return limitViolationMessages;
    }

    private static void checkTimeLimit(PreCommitLimitsOption limits, String currentUser, PublicProjectId project, PreCommitUserInfoIndex userInfoIndex, List<PreCommit3Result.PreCommit3ErrorDetail> detailedErrors) throws StorageException {
        Duration timeLimit;
        OptionalLong lastPreCommit = userInfoIndex.getLastUpload(currentUser, project);
        if (!lastPreCommit.isPresent()) {
            return;
        }
        Instant now = DateTimeUtils.now();
        Duration durationSinceLastProcessedRequest = Duration.between(Instant.ofEpochMilli(lastPreCommit.getAsLong()), now);
        if (durationSinceLastProcessedRequest.compareTo(timeLimit = Duration.ofSeconds(limits.timeLimit)) < 0) {
            String message = "Pre-Commit is limited to use every " + limits.timeLimit + "s. You used it last time for " + String.valueOf(project) + " " + durationSinceLastProcessedRequest.getSeconds() + " seconds ago.";
            detailedErrors.add(PreCommit3Result.PreCommit3ErrorDetail.createFileIndependentError((PreCommit3Result.EPrecommit3ErrorType)PreCommit3Result.EPrecommit3ErrorType.USER_TIME_LIMIT, (String)message, (boolean)true));
        }
    }

    private static void checkFileSizeLimit(PreCommitUploadData data, PreCommitLimitsOption limits, List<PreCommit3Result.PreCommit3ErrorDetail> detailedErrors) {
        long fileSizeInBytes = FileSystemUtils.parseDataSize((String)limits.fileSize);
        for (Map.Entry file : data.getUniformPathToContentMap().entrySet()) {
            int size = ((String)file.getValue()).getBytes(StandardCharsets.UTF_8).length;
            if ((long)size <= fileSizeInBytes) continue;
            String message = "File " + (String)file.getKey() + " is with " + (double)size / 1000.0 + " kB too large. The maximum allowed filesize is " + limits.fileSize + ".";
            detailedErrors.add(PreCommit3Result.PreCommit3ErrorDetail.createErrorForFile((PreCommit3Result.EPrecommit3ErrorType)PreCommit3Result.EPrecommit3ErrorType.FILE_SIZE_LIMIT, (String)message, (String)((String)file.getKey()), (boolean)true));
        }
    }

    private static void checkFileCountLimit(PreCommitUploadData data, PreCommitLimitsOption limits, List<PreCommit3Result.PreCommit3ErrorDetail> detailedErrors) {
        int count = data.getUniformPathToContentMap().size();
        if (count > limits.fileCount) {
            String message = "Too many files. This Pre-Commit contains " + count + " added or modified files, but only " + limits.fileCount + " are allowed.";
            detailedErrors.add(PreCommit3Result.PreCommit3ErrorDetail.createFileIndependentError((PreCommit3Result.EPrecommit3ErrorType)PreCommit3Result.EPrecommit3ErrorType.FILE_COUNT_LIMIT, (String)message, (boolean)true));
        }
    }
}

