/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.precommit.debug;

import com.google.common.math.Quantiles;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.precommit.PrecommitStatisticsIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.NonNull;

@Path(value="api/pre-commit/debug/statistics")
public class PreCommitStatisticsService
extends ApiBase {
    @GET
    @Operation(summary="Retrieve statistics on usage of the precommit service", description="Provides various statistics on usage and performance of the precommit feature (exclusively for the new \"precommit3\" feature).", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.VIEW_SYSTEM_STATUS})
    public String retrievePrecommitStatistics() throws StorageException {
        PrecommitStatisticsIndex index = this.openGlobalIndex(PrecommitStatisticsIndex.class);
        UnmodifiableList precommitTasks = index.getAllPreCommitTasks();
        StringBuilder result = new StringBuilder("Statistics on precommit tasks executed since creation of this Teamscale instance (since creation of the database).\n");
        PreCommitStatisticsService.appendPrecommitCompletionDurationStatistics((UnmodifiableList<PrecommitStatisticsIndex.PrecommitTaskInfo>)precommitTasks, result);
        PreCommitStatisticsService.appendIncompleteTaskStatistics((UnmodifiableList<PrecommitStatisticsIndex.PrecommitTaskInfo>)precommitTasks, result);
        PreCommitStatisticsService.appendUserStatistics((UnmodifiableList<PrecommitStatisticsIndex.PrecommitTaskInfo>)precommitTasks, result);
        PreCommitStatisticsService.appendTaskCountStatistics((UnmodifiableList<PrecommitStatisticsIndex.PrecommitTaskInfo>)precommitTasks, result);
        PreCommitStatisticsService.appendTaskSizeStatistics((UnmodifiableList<PrecommitStatisticsIndex.PrecommitTaskInfo>)precommitTasks, result);
        return result.toString();
    }

    private static void appendPrecommitCompletionDurationStatistics(UnmodifiableList<PrecommitStatisticsIndex.PrecommitTaskInfo> precommitTaskInfos, StringBuilder stringBuilder) {
        List<Double> durationsSeconds = precommitTaskInfos.stream().filter(task -> task.getTaskTerminationInstant() != null).map(task -> (double)Duration.between(task.taskCreationInstant, task.getTaskTerminationInstant()).toMillis() / 1000.0).toList();
        stringBuilder.append("\n\nOverall Time until a precommit task is completed (in seconds):\n");
        PreCommitStatisticsService.appendQuartiles(stringBuilder, durationsSeconds);
        List<Integer> pollingEvents = precommitTaskInfos.stream().filter(task -> task.getTaskTerminationInstant() != null).map(PrecommitStatisticsIndex.PrecommitTaskInfo::getNumberOfPolls).toList();
        stringBuilder.append("\n\nNumber of polling events until a precommit task is completed (not counting the final polling event that returned the precommit results):\n");
        PreCommitStatisticsService.appendQuartiles(stringBuilder, pollingEvents);
    }

    private static void appendIncompleteTaskStatistics(UnmodifiableList<PrecommitStatisticsIndex.PrecommitTaskInfo> precommitTasks, StringBuilder result) {
        List<PrecommitStatisticsIndex.PrecommitTaskInfo> incompleteTasks = precommitTasks.stream().filter(task -> task.getTaskTerminationInstant() == null).toList();
        result.append("\n\nStatistics on incomplete precommit tasks:\n");
        result.append(incompleteTasks.size() + " Tasks are currently incomplete.\n");
        List<PrecommitStatisticsIndex.PrecommitTaskInfo> olderThanFifteenMinutes = PreCommitStatisticsService.filterTasksCreatedBefore(incompleteTasks, Instant.now().minus(15L, ChronoUnit.MINUTES));
        result.append("\t").append(olderThanFifteenMinutes.size() + " incomplete tasks were started more than 15 minutes ago.\n");
        List<PrecommitStatisticsIndex.PrecommitTaskInfo> olderThanOneHour = PreCommitStatisticsService.filterTasksCreatedBefore(olderThanFifteenMinutes, Instant.now().minus(1L, ChronoUnit.HOURS));
        result.append("\t").append(olderThanOneHour.size() + " incomplete tasks were started more than an hour ago.\n");
        List<PrecommitStatisticsIndex.PrecommitTaskInfo> olderThanOneDay = PreCommitStatisticsService.filterTasksCreatedBefore(olderThanOneHour, Instant.now().minus(1L, ChronoUnit.DAYS));
        result.append("\t").append(olderThanOneDay.size() + " incomplete tasks were started more than one day ago.\n");
    }

    private static void appendUserStatistics(UnmodifiableList<PrecommitStatisticsIndex.PrecommitTaskInfo> precommitTasks, StringBuilder result) {
        CounterSet tasksPerUser = new CounterSet();
        for (PrecommitStatisticsIndex.PrecommitTaskInfo task : precommitTasks) {
            tasksPerUser.inc((Object)task.username);
        }
        result.append("\n\n").append(tasksPerUser.values().size()).append(" users started precommit tasks.\n");
        result.append("\nStarted tasks per user:\n");
        PreCommitStatisticsService.appendQuartiles(result, tasksPerUser.values());
    }

    private static void appendTaskCountStatistics(UnmodifiableList<PrecommitStatisticsIndex.PrecommitTaskInfo> precommitTasks, StringBuilder result) {
        result.append("\n\nStatistics on precommit tasks:\n");
        result.append("\t").append(precommitTasks.size() + " tasks were started since creation of the database.\n");
        List<PrecommitStatisticsIndex.PrecommitTaskInfo> newerThanOneDay = PreCommitStatisticsService.filterTasksCreatedAfter(precommitTasks, Instant.now().minus(1L, ChronoUnit.DAYS));
        result.append("\t").append(newerThanOneDay.size() + " tasks were started since one day ago.\n");
        List<PrecommitStatisticsIndex.PrecommitTaskInfo> newerThanOneHour = PreCommitStatisticsService.filterTasksCreatedAfter(newerThanOneDay, Instant.now().minus(1L, ChronoUnit.HOURS));
        result.append("\t").append(newerThanOneHour.size() + " tasks were started since an hour ago.\n");
        List<PrecommitStatisticsIndex.PrecommitTaskInfo> newerThanFifteenMinutes = PreCommitStatisticsService.filterTasksCreatedAfter(newerThanOneHour, Instant.now().minus(15L, ChronoUnit.MINUTES));
        result.append("\t").append(newerThanFifteenMinutes.size() + " tasks were started since 15 minutes ago.\n");
        List<PrecommitStatisticsIndex.EPrecommitTaskTerminationReason> terminationReasons = precommitTasks.stream().map(PrecommitStatisticsIndex.PrecommitTaskInfo::getTaskTerminationReason).filter(Objects::nonNull).toList();
        for (PrecommitStatisticsIndex.EPrecommitTaskTerminationReason terminationReason : PrecommitStatisticsIndex.EPrecommitTaskTerminationReason.values()) {
            long numTasksWithCurrentReason = terminationReasons.stream().filter(reason -> reason == terminationReason).count();
            result.append("\t").append(numTasksWithCurrentReason + " tasks were terminated with reason ").append(terminationReason.toString()).append(".\n");
        }
    }

    private static void appendTaskSizeStatistics(UnmodifiableList<PrecommitStatisticsIndex.PrecommitTaskInfo> precommitTasks, StringBuilder result) {
        List<Integer> numberOfFilesPerTask = precommitTasks.stream().map(task -> task.numberOfNewOrChangedFiles).toList();
        result.append("\n\nNumber of uploaded files (ignoring deletions) per precommit task:\n");
        PreCommitStatisticsService.appendQuartiles(result, numberOfFilesPerTask);
        List<Integer> numberOfDeletedFilesPerTask = precommitTasks.stream().map(task -> task.numberOfDeletedFiles).toList();
        result.append("\n\nNumber of deleted files per precommit task:\n");
        PreCommitStatisticsService.appendQuartiles(result, numberOfDeletedFilesPerTask);
        List<Long> sizeOfFilesPerTask = precommitTasks.stream().map(task -> task.numberOfContentChars).toList();
        result.append("\n\nSize of uploaded files (ignoring deletions) per precommit task (in number-of-chars):\n");
        PreCommitStatisticsService.appendQuartiles(result, sizeOfFilesPerTask);
    }

    private static void appendQuartiles(StringBuilder result, Collection<? extends Number> data) {
        if (data.isEmpty()) {
            result.append("\tno data available\n");
        }
        Map quartiles = Quantiles.quartiles().indexes(new int[]{0, 1, 2, 3, 4}).compute(data);
        result.append("\tmin:       ").append(quartiles.get(0)).append("\n");
        result.append("\tquartile1: ").append(quartiles.get(1)).append("\n");
        result.append("\tmedian:    ").append(quartiles.get(2)).append("\n");
        result.append("\tquartile3: ").append(quartiles.get(3)).append("\n");
        result.append("\tmax:       ").append(quartiles.get(4)).append("\n");
    }

    private static @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    PrecommitStatisticsIndex.PrecommitTaskInfo> filterTasksCreatedBefore(List<PrecommitStatisticsIndex.PrecommitTaskInfo> precommitTasks, Instant thresholdTimestamp) {
        return precommitTasks.stream().filter(task -> task.taskCreationInstant.isBefore(thresholdTimestamp)).toList();
    }

    private static @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    PrecommitStatisticsIndex.PrecommitTaskInfo> filterTasksCreatedAfter(List<PrecommitStatisticsIndex.PrecommitTaskInfo> precommitTasks, Instant thresholdTimestamp) {
        return precommitTasks.stream().filter(task -> task.taskCreationInstant.isAfter(thresholdTimestamp)).toList();
    }
}

