/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.configuration.ReviewAnalysisConfiguration;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.requirements_tracing.connectors.RequirementsManagementToolConnectorDescriptorBase;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/feature")
public class ProjectFeatureService
extends ApiBase {
    @GET
    @Path(value="review-finding")
    @Operation(summary="Availability of review findings", description="Returns true if review findings are enabled in the project for the given code-scope", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public boolean isReviewFindingsEnabled(@QueryParam(value="uniform-path") UniformPath uniformPath, @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        return ReviewAnalysisConfiguration.isCodeReviewFindingSupportEnabled((UniformPath)uniformPath, (ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)HistoryAccessOption.readCommit((CommitDescriptor)this.resolve(commit)));
    }

    @GET
    @Path(value="merge-request")
    @Operation(summary="Availability of merge requests", description="Returns true if merge requests are configured for the project", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public boolean isMergeRequestsEnabled() {
        return this.getProjectStorageSystem().hasIndex(MergeRequestIndex.class);
    }

    @GET
    @Path(value="spec-item")
    @Operation(summary="Availability of spec-item analysis", description="Determines whether spec-item analysis is enabled for the project", tags={"Specification Items"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public boolean isSpecItemAnalysisEnabled() throws StorageException {
        return RequirementsManagementToolConnectorDescriptorBase.isSpecItemAnalysisEnabled((IProjectId)this.serviceInfo.getPrimaryPublicId(), (IndexLayer)this.getIndexLayer());
    }
}

