/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.analysis_profile;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.configuration.tools.SwiftLintConfiguration;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.project.analysis_profile.AnalysisProfileImportUtils;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.CheckMappingAndCheckOptionTSVUtils;
import eu.cqse.check.framework.core.registry.CheckMapping;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.jspecify.annotations.NonNull;
import org.yaml.snakeyaml.Yaml;

@Path(value="api/import-swiftlint-configuration")
public class SwiftLintConfigurationImportService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Collection<CheckMapping> CHECK_MAPPINGS = SwiftLintConfigurationImportService.readCheckMappings();
    private static final Set<String> SWIFTLINT_DEFAULT_RULES = SwiftLintConfigurationImportService.readSwiftLintDefaultRules();
    private final Yaml yaml = new Yaml();

    @POST
    @Operation(summary="Upload SwiftLint Configuration", description="Uploads SwiftLint Configurations which are then converted to Teamscale analysis profiles. Returns a textual summary of the import process", tags={"Analysis profiles"})
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_ANALYSIS_PROFILES})
    @Consumes(value={"multipart/form-data"})
    public SwiftLintConfigurationImportSummary importSwiftLintConfiguration(@Parameter(required=true, schema=@Schema(type="string", format="binary")) @FormDataParam(value="configuration") FormDataBodyPart configuration, @FormDataParam(value="enable-teamscale-defaults") boolean enableTeamscaleDefaults) throws ProjectConfigurationException, StorageException, IOException {
        SwiftLintConfigurationImportSummary importSummary = new SwiftLintConfigurationImportSummary();
        Map<String, String> groupToQualityIndicatorMapping = SwiftLintConfigurationImportService.getAnalysisGroupToQualityIndicatorMapping();
        Map<String, CheckMapping> checkMappingById = CHECK_MAPPINGS.stream().collect(Collectors.toMap(checkMapping -> checkMapping.checkId, checkMapping -> checkMapping));
        this.importConfiguration(importSummary, groupToQualityIndicatorMapping, checkMappingById, configuration, enableTeamscaleDefaults);
        return importSummary;
    }

    private static @NonNull Set<String> readSwiftLintDefaultRules() {
        try {
            return CollectionUtils.filterToSet((Collection)CollectionUtils.asHashSet((Object[])StringUtils.splitLines((String)FileSystemUtils.readStream((InputStream)SwiftLintConfigurationImportService.class.getResourceAsStream("swiftlint-default-rules.txt"), (Charset)StandardCharsets.UTF_8))), line -> !line.startsWith("#"));
        }
        catch (IOException e) {
            LOGGER.error("IO error reading SwiftLint default rules file: " + String.valueOf(e), (Throwable)e);
            return Collections.emptySet();
        }
    }

    private void importConfiguration(SwiftLintConfigurationImportSummary importSummary, Map<String, String> groupToQualityIndicatorMapping, Map<String, CheckMapping> checkMappingById, FormDataBodyPart configuration, boolean enableTeamscaleDefaults) throws ProjectConfigurationException, StorageException {
        ConfigurationTemplate configurationTemplate = AnalysisProfileImportUtils.createConfigurationTemplate(EAnalysisTool.SWIFT_LINT, EnumSet.of(ELanguage.SWIFT), enableTeamscaleDefaults, groupToQualityIndicatorMapping, this.getGlobalStorageSystem());
        AnalysisProfile analysisProfile = SwiftLintConfigurationImportService.createAnalysisProfile(SwiftLintConfigurationImportService.getAnalysisProfileName(configuration), configurationTemplate);
        importSummary.profileNames.add(analysisProfile.getName());
        Map<String, AnalysisGroup> analysisGroupsByName = AnalysisProfileImportUtils.getAnalysisGroupsByName(analysisProfile);
        Map configurationYaml = (Map)this.yaml.load((InputStream)configuration.getEntityAs(InputStream.class));
        Set<String> disabledRules = SwiftLintConfigurationImportService.getRuleList(configurationYaml, "disabled_rules");
        Set<String> optInRules = SwiftLintConfigurationImportService.getRuleList(configurationYaml, "opt_in_rules");
        Set<String> onlyRules = SwiftLintConfigurationImportService.getRuleList(configurationYaml, "only_rules");
        if (!CollectionUtils.isNullOrEmpty(onlyRules)) {
            SwiftLintConfigurationImportService.importOnlyGivenRules(importSummary, checkMappingById, analysisGroupsByName, onlyRules, configurationYaml);
        } else {
            SwiftLintConfigurationImportService.importOptInAndDisabledRules(importSummary, checkMappingById, analysisGroupsByName, disabledRules, optInRules, configurationYaml);
        }
        if (!enableTeamscaleDefaults) {
            AnalysisProfileImportUtils.disableAllChecksExcept(analysisGroupsByName.values(), checkMappingById.keySet(), configurationTemplate);
        }
        AnalysisProfileImportUtils.writeProfile(analysisProfile, this.getIndexLayer(), this.getPermissions());
    }

    private static void importOptInAndDisabledRules(SwiftLintConfigurationImportSummary importSummary, Map<String, CheckMapping> checkMappingById, Map<String, AnalysisGroup> analysisGroupsByName, Set<String> disabledRules, Set<String> optInRules, Map<String, Object> configurationYaml) {
        HashMap<String, EFindingEnablement> enablementByCheckId = new HashMap<String, EFindingEnablement>();
        CHECK_MAPPINGS.forEach(checkMapping -> enablementByCheckId.put(checkMapping.checkId, checkMapping.defaultEnablement));
        importSummary.unsupportedChecks.addAll(new ArrayList(CollectionUtils.subtract(disabledRules, checkMappingById.keySet())));
        importSummary.unsupportedChecks.addAll(new ArrayList(CollectionUtils.subtract(optInRules, checkMappingById.keySet())));
        for (String swiftLintDefaultRule : SWIFTLINT_DEFAULT_RULES) {
            enablementByCheckId.put(swiftLintDefaultRule, SwiftLintConfigurationImportService.getRuleEnablement(swiftLintDefaultRule, configurationYaml));
        }
        for (String optInRule : optInRules) {
            enablementByCheckId.put(optInRule, SwiftLintConfigurationImportService.getRuleEnablement(optInRule, configurationYaml));
        }
        for (String disabledRule : disabledRules) {
            enablementByCheckId.put(disabledRule, EFindingEnablement.OFF);
        }
        SwiftLintConfigurationImportService.setCheckEnablement(analysisGroupsByName, enablementByCheckId);
    }

    private static EFindingEnablement getRuleEnablement(String rule, Map<String, Object> configurationYaml) {
        String yamlSetting = String.valueOf(configurationYaml.get(rule));
        if ("error".equals(yamlSetting) || yamlSetting.contains("severity=error")) {
            return EFindingEnablement.RED;
        }
        return EFindingEnablement.YELLOW;
    }

    private static void importOnlyGivenRules(SwiftLintConfigurationImportSummary importSummary, Map<String, CheckMapping> checkMappingById, Map<String, AnalysisGroup> analysisGroupsByName, Set<String> onlyRules, Map<String, Object> configurationYaml) {
        importSummary.unsupportedChecks.addAll(new ArrayList(CollectionUtils.subtract(onlyRules, checkMappingById.keySet())));
        HashSet supportedRules = CollectionUtils.intersectionSet(onlyRules, (Collection[])new Collection[]{checkMappingById.keySet()});
        HashMap<String, EFindingEnablement> enablementByCheckId = new HashMap<String, EFindingEnablement>();
        CHECK_MAPPINGS.forEach(checkMapping -> enablementByCheckId.put(checkMapping.checkId, EFindingEnablement.OFF));
        supportedRules.forEach(rule -> enablementByCheckId.put((String)rule, SwiftLintConfigurationImportService.getRuleEnablement(rule, configurationYaml)));
        SwiftLintConfigurationImportService.setCheckEnablement(analysisGroupsByName, enablementByCheckId);
    }

    private static String getAnalysisProfileName(FormDataBodyPart bodyPart) {
        return StringUtils.stripSuffix((String)bodyPart.getContentDisposition().getFileName(), (String)".yml");
    }

    private static void setCheckEnablement(Map<String, AnalysisGroup> analysisGroupsByName, Map<String, EFindingEnablement> enablementByCheckId) {
        for (CheckMapping checkMapping : CHECK_MAPPINGS) {
            String groupName = checkMapping.group;
            analysisGroupsByName.get(groupName).setOptionValue(checkMapping.checkId, enablementByCheckId.get(checkMapping.checkId).toString());
        }
    }

    private static Map<String, String> getAnalysisGroupToQualityIndicatorMapping() {
        HashMap<String, String> groupToQualityIndicatorMapping = new HashMap<String, String>();
        for (CheckMapping checkMapping : CHECK_MAPPINGS) {
            groupToQualityIndicatorMapping.put(checkMapping.group, checkMapping.category);
        }
        return groupToQualityIndicatorMapping;
    }

    private static @NonNull AnalysisProfile createAnalysisProfile(String profileName, ConfigurationTemplate configurationTemplate) {
        AnalysisProfile analysisProfile = new AnalysisProfile(profileName, EnumSet.of(ELanguage.SWIFT), Set.of(EAnalysisTool.SWIFT_LINT));
        AnalysisProfileUtils.createQualityIndicators((AnalysisProfile)analysisProfile, (ConfigurationTemplate)configurationTemplate);
        AnalysisProfileUtils.createGlobalOptions((AnalysisProfile)analysisProfile, (ConfigurationTemplate)configurationTemplate);
        return analysisProfile;
    }

    private static Set<String> getRuleList(Map<String, Object> parsedYaml, String ruleListName) {
        List rules = (List)parsedYaml.get(ruleListName);
        if (rules == null) {
            return Collections.emptySet();
        }
        return CollectionUtils.mapToSet((Collection)rules, Object::toString);
    }

    private static Collection<CheckMapping> readCheckMappings() {
        Resource mappingsFile = Resource.of(SwiftLintConfiguration.class, (String)"message/swiftlint/check-mappings.tsv");
        return CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv((Resource)mappingsFile).values().stream().filter(mapping -> mapping.defaultEnablement != null).collect(Collectors.toList());
    }

    public static class SwiftLintConfigurationImportSummary {
        @JsonProperty(value="unsupportedChecks")
        private Set<String> unsupportedChecks = new HashSet<String>();
        @JsonProperty(value="profileNames")
        private List<String> profileNames = new ArrayList<String>();

        private SwiftLintConfigurationImportSummary() {
        }
    }
}

