/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.user.User;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.user.UserRecentlyInteractedBranchesIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.repository.BranchesInfo;
import com.teamscale.service.repository.BranchesServiceRequestOptions;
import com.teamscale.service.repository.Legacy64BranchesInfo;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.GitRefUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.NumbersAwareStringComparator;

@Path(value="api/projects/{project}/branches")
public class ProjectBranchesService
extends ApiBase {
    private static final String GET_BRANCHES_WITH_PAGINATION_DESCRIPTION = "Returns the specified range of sorted branches (or all if no range specified), including/excluding deleted/anonymous branches or the sorted filtered branches based on the defined branchesFilter/regexFilter as BranchesInfo.";

    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_5_3_0, deprecatedSince=ETeamscaleVersion.VERSION_6_5_0)
    @Operation(summary="Get branches info", description="Gets the branches info containing a branch alias specific to the requesting user for the precommit branch.", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    public Legacy64BranchesInfo getBranches() throws StorageException {
        ProjectRepositoryChangeIndex projectRepositoryChangeIndex = this.openProjectIndex(ProjectRepositoryChangeIndex.class, null);
        UserRecentlyInteractedBranchesIndex userRecentlyInteractedBranchesIndex = this.openProjectIndex(UserRecentlyInteractedBranchesIndex.class, null);
        return this.getBranchesInfo(this.getPermissions(), this.getUser(), projectRepositoryChangeIndex, userRecentlyInteractedBranchesIndex);
    }

    private Legacy64BranchesInfo getBranchesInfo(ServicePermissions servicePermissions, User currentUser, ProjectRepositoryChangeIndex projectRepositoryChangeIndex, UserRecentlyInteractedBranchesIndex userRecentlyInteractedBranchesIndex) throws StorageException {
        ProjectRepositoryChangeIndex.ProjectRepositoryStatus repositoryStatus = projectRepositoryChangeIndex.getRepositoryStatus();
        Set<String> allBranches = ProjectBranchesService.filterHiddenBranches(servicePermissions, repositoryStatus.getBranchNames(), currentUser.getUsername());
        Set<String> liveBranches = ProjectBranchesService.getLiveBranches(this.getPermissions(), repositoryStatus, currentUser.getUsername());
        List<String> recentBranches = userRecentlyInteractedBranchesIndex.getRecentlyInteractedBranches(currentUser).stream().filter(liveBranches::contains).limit(5L).collect(Collectors.toList());
        return new Legacy64BranchesInfo(repositoryStatus.getDefaultBranchName(), CollectionUtils.sort(liveBranches, (Comparator)NumbersAwareStringComparator.INSTANCE), CollectionUtils.sort((Collection)CollectionUtils.differenceSet(allBranches, (Collection[])new Collection[]{liveBranches}), (Comparator)NumbersAwareStringComparator.INSTANCE), recentBranches);
    }

    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_6_5_0)
    @Operation(summary="Get branches", description="Returns the specified range of sorted branches (or all if no range specified), including/excluding deleted/anonymous branches or the sorted filtered branches based on the defined branchesFilter/regexFilter as BranchesInfo.", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    public BranchesInfo getBranchesGetRequest(@BeanParam BranchesServiceRequestOptions branchesServiceRequestOptions) throws StorageException {
        BranchesInfo branchesInfo = ProjectBranchesService.getBranchesInfo(this.getPermissions(), branchesServiceRequestOptions.isOnlyLive(), this.openProjectIndex(ProjectRepositoryChangeIndex.class, null), this.getUser().getUsername());
        List<String> branchesFilter = branchesServiceRequestOptions.getExactBranchesFilter();
        if (branchesFilter != null && !branchesFilter.isEmpty()) {
            return ProjectBranchesService.getSortedAndFilteredBranchesInfo(branchesInfo, branchesFilter);
        }
        return ProjectBranchesService.getSortedAndPaginatedBranchesInfo(branchesInfo, branchesServiceRequestOptions);
    }

    @POST
    @PublicApi(since=ETeamscaleVersion.VERSION_6_5_0)
    @Operation(summary="Get branches", description="Returns the specified range of sorted branches (or all if no range specified), including/excluding deleted/anonymous branches or the sorted filtered branches based on the defined branchesFilter/regexFilter as BranchesInfo.", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public BranchesInfo getBranchesPostRequest(@BeanParam BranchesServiceRequestOptions branchesServiceRequestOptions) throws StorageException {
        return this.getBranchesGetRequest(branchesServiceRequestOptions);
    }

    public static BranchesInfo getBranchesInfo(ServicePermissions servicePermissions, boolean isOnlyLive, ProjectRepositoryChangeIndex projectRepositoryChangeIndex, String currentUser) throws StorageException {
        ProjectRepositoryChangeIndex.ProjectRepositoryStatus repositoryStatus = projectRepositoryChangeIndex.getRepositoryStatus();
        Set<String> allBranches = ProjectBranchesService.filterHiddenBranches(servicePermissions, repositoryStatus.getBranchNames(), currentUser);
        Set<String> liveBranches = ProjectBranchesService.getLiveBranches(servicePermissions, repositoryStatus, currentUser);
        Set<String> virtualBranches = ProjectBranchesService.getVirtualBranches(repositoryStatus.getBranchNames());
        HashSet<String> anonymousBranches = new HashSet<String>();
        Set<String> nonAnonymousLiveBranches = ProjectBranchesService.getNonAnonymousBranches(liveBranches, anonymousBranches);
        Set<String> nonAnonymousDeletedBranches = ProjectBranchesService.getNonAnonymousBranches(CollectionUtils.differenceSet(allBranches, (Collection[])new Collection[]{liveBranches}), anonymousBranches);
        nonAnonymousDeletedBranches.retainAll(repositoryStatus.getBranchesWithCommits());
        BranchesInfo branchesInfo = new BranchesInfo();
        branchesInfo.addLiveBranches(nonAnonymousLiveBranches);
        if (!isOnlyLive) {
            branchesInfo.addDeletedBranches(nonAnonymousDeletedBranches);
            branchesInfo.addAnonymousBranches(anonymousBranches);
            branchesInfo.addVirtualBranches(virtualBranches);
        }
        return branchesInfo;
    }

    private static Set<String> getVirtualBranches(Set<String> branchNames) {
        return CollectionUtils.filterToSet(branchNames, ProjectBranchesService::isVirtualBranch);
    }

    public static Set<String> getLiveBranches(ServicePermissions servicePermissions, ProjectRepositoryChangeIndex.ProjectRepositoryStatus repositoryStatus, String currentUser) {
        Set<String> allBranches = ProjectBranchesService.filterHiddenBranches(servicePermissions, repositoryStatus.getBranchNames(), currentUser);
        Set liveBranches = repositoryStatus.getLiveBranchNames();
        liveBranches.add(repositoryStatus.getDefaultBranchName());
        liveBranches.addAll(CollectionUtils.filter(allBranches, PreCommitUtils::isPrecommitBranch));
        liveBranches.retainAll(allBranches);
        return liveBranches;
    }

    private static Set<String> filterHiddenBranches(ServicePermissions servicePermissions, Set<String> branches, String currentUser) {
        boolean hasAdminServiceAccess = servicePermissions.hasGlobalPermission(EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES);
        return CollectionUtils.filterToSet(branches, branch -> {
            if (!hasAdminServiceAccess && PreCommitUtils.isPrecommitBranch((String)branch)) {
                return PreCommitUtils.extractPrecommitUserName((String)branch).equals(currentUser);
            }
            return !ProjectBranchesService.isVirtualBranch(branch);
        });
    }

    private static boolean isVirtualBranch(String branch) {
        return SpecItemIndex.isRequirementsManagementConnectorBranch((String)branch);
    }

    private static Set<String> getNonAnonymousBranches(Set<String> sourceBranches, Set<String> anonymousBranches) {
        HashSet<String> result = new HashSet<String>();
        for (String branchName : sourceBranches) {
            if (GitRefUtils.isAnonymousBranchName((String)branchName)) {
                anonymousBranches.add(branchName);
                continue;
            }
            result.add(branchName);
        }
        return result;
    }

    private static BranchesInfo getSortedAndFilteredBranchesInfo(BranchesInfo branchesInfo, List<String> branchesFilter) {
        List<String> liveBranches = branchesInfo.getLiveBranches();
        List<String> deletedBranches = branchesInfo.getDeletedBranches();
        List<String> anonymousBranches = branchesInfo.getAnonymousBranches();
        List<String> virtualBranches = branchesInfo.getVirtualBranches();
        BranchesInfo filteredBranchesInfo = new BranchesInfo();
        filteredBranchesInfo.addLiveBranches(CollectionUtils.intersectionSet(branchesFilter, (Collection[])new Collection[]{liveBranches}));
        filteredBranchesInfo.addDeletedBranches(CollectionUtils.intersectionSet(branchesFilter, (Collection[])new Collection[]{deletedBranches}));
        filteredBranchesInfo.addAnonymousBranches(CollectionUtils.intersectionSet(branchesFilter, (Collection[])new Collection[]{anonymousBranches}));
        filteredBranchesInfo.addVirtualBranches(CollectionUtils.intersectionSet(branchesFilter, (Collection[])new Collection[]{virtualBranches}));
        filteredBranchesInfo.sortBranches();
        return filteredBranchesInfo;
    }

    public static BranchesInfo getSortedAndPaginatedBranchesInfo(BranchesInfo branchesInfo, BranchesServiceRequestOptions branchesServiceRequestOptions) {
        String filter = branchesServiceRequestOptions.getFilter();
        if (filter != null) {
            branchesInfo = ProjectBranchesService.searchBranches(filter.toLowerCase(), branchesInfo);
        }
        if (branchesServiceRequestOptions.getStartOffset() >= branchesInfo.getCurrentBranchesCount()) {
            return new BranchesInfo();
        }
        branchesInfo.sortBranches();
        return ProjectBranchesService.getPaginatedBranchesInfo(branchesServiceRequestOptions, branchesInfo);
    }

    private static BranchesInfo getPaginatedBranchesInfo(BranchesServiceRequestOptions branchesServiceRequestOptions, BranchesInfo branchesInfo) {
        int endOffset = branchesServiceRequestOptions.getStartOffset() + branchesServiceRequestOptions.getLimit();
        if (endOffset > branchesInfo.getCurrentBranchesCount() || branchesServiceRequestOptions.getLimit() == 0) {
            endOffset = branchesInfo.getCurrentBranchesCount();
        }
        int startOffset = branchesServiceRequestOptions.getStartOffset();
        return ProjectBranchesService.getPaginatedBranchesInfo(startOffset, endOffset, branchesInfo);
    }

    private static BranchesInfo getPaginatedBranchesInfo(int startOffset, int endOffset, BranchesInfo branchesInfo) {
        BranchesInfo paginatedBranchesInfo = new BranchesInfo();
        PairList branchesWithApplier = new PairList();
        branchesWithApplier.add(branchesInfo.getLiveBranches(), paginatedBranchesInfo::addLiveBranches);
        branchesWithApplier.add(branchesInfo.getDeletedBranches(), paginatedBranchesInfo::addDeletedBranches);
        branchesWithApplier.add(branchesInfo.getAnonymousBranches(), paginatedBranchesInfo::addAnonymousBranches);
        branchesWithApplier.add(branchesInfo.getVirtualBranches(), paginatedBranchesInfo::addVirtualBranches);
        for (Pair branchAndConsumer : branchesWithApplier) {
            List branchesList = (List)branchAndConsumer.getFirst();
            Consumer paginatedBranchesConsumer = (Consumer)branchAndConsumer.getSecond();
            if (endOffset > 0 && startOffset < branchesList.size()) {
                int branchesEndOffset = Math.min(endOffset, branchesList.size());
                paginatedBranchesConsumer.accept(branchesList.subList(startOffset, branchesEndOffset));
                endOffset -= branchesEndOffset;
                startOffset = 0;
            }
            if (startOffset == 0) continue;
            startOffset -= branchesList.size();
        }
        return paginatedBranchesInfo;
    }

    private static BranchesInfo searchBranches(String filter, BranchesInfo branchesInfo) {
        BranchesInfo matchingBranchesInfo = new BranchesInfo();
        matchingBranchesInfo.addLiveBranches(ProjectBranchesService.getFilteredBranches(filter, branchesInfo.getLiveBranches()));
        matchingBranchesInfo.addDeletedBranches(ProjectBranchesService.getFilteredBranches(filter, branchesInfo.getDeletedBranches()));
        matchingBranchesInfo.addAnonymousBranches(ProjectBranchesService.getFilteredBranches(filter, branchesInfo.getAnonymousBranches()));
        matchingBranchesInfo.addVirtualBranches(ProjectBranchesService.getFilteredBranches(filter, branchesInfo.getVirtualBranches()));
        return matchingBranchesInfo;
    }

    private static Set<String> getFilteredBranches(String filter, List<String> branches) {
        return branches.stream().filter(branch -> branch.toLowerCase().contains(filter) || PreCommitUtils.isPrecommitBranch((String)branch) && "'s pre-commit branch".toLowerCase().contains(filter)).collect(Collectors.toSet());
    }
}

