/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.user.UserRecentlyInteractedBranchesIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.repository.ProjectBranchesService;
import com.teamscale.service.repository.UserRecentlyInteractedBranchesAnalysisStateContributor;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/recent-branches")
public class ProjectRecentBranchesService
extends ApiBase {
    public static final int MAX_RECENT_BRANCHES = 5;

    @GET
    @Operation(summary="Get recent branches", description="Returns the recently visited branches.", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, UserRecentlyInteractedBranchesAnalysisStateContributor.class})
    public List<String> getRecentBranches() throws StorageException {
        ProjectRepositoryChangeIndex projectRepositoryChangeIndex = this.openProjectIndex(ProjectRepositoryChangeIndex.class, null);
        UserRecentlyInteractedBranchesIndex userRecentlyInteractedBranchesIndex = this.openProjectIndex(UserRecentlyInteractedBranchesIndex.class, null);
        ProjectRepositoryChangeIndex.ProjectRepositoryStatus repositoryStatus = projectRepositoryChangeIndex.getRepositoryStatus();
        return ProjectRecentBranchesService.getRecentBranches(this.getPermissions(), userRecentlyInteractedBranchesIndex, repositoryStatus, this.getUser());
    }

    @POST
    @Path(value="{branchName}")
    @Operation(summary="Mark branch as visited", description="Adds the given branch to the list of recently viewed branches.")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public void registerVisitedBranch(@PathParam(value="branchName") String branchName) throws StorageException {
        UserRecentlyInteractedBranchesIndex userRecentlyInteractedBranchesIndex = this.openProjectIndex(UserRecentlyInteractedBranchesIndex.class, null);
        userRecentlyInteractedBranchesIndex.registerInteractedBranch(this.getUser(), branchName, System.currentTimeMillis());
    }

    public static List<String> getRecentBranches(ServicePermissions servicePermissions, UserRecentlyInteractedBranchesIndex userRecentlyInteractedBranchesIndex, ProjectRepositoryChangeIndex.ProjectRepositoryStatus repositoryStatus, User currentUser) throws StorageException {
        return userRecentlyInteractedBranchesIndex.getRecentlyInteractedBranches(currentUser).stream().filter(ProjectBranchesService.getLiveBranches(servicePermissions, repositoryStatus, currentUser.getUsername())::contains).limit(5L).collect(Collectors.toList());
    }
}

