/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.service.repository.RepositorySummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class RepositoryActivitySummary
extends RepositorySummary {
    private static final long serialVersionUID = 1L;
    private static final String COMMITS_LAST_24_HOURS_PROPERTY = "commitsLast24Hours";
    private static final String COMMITS_LAST_7_DAYS_PROPERTY = "commitsLast7Days";
    private static final String COMMITS_LAST_30_DAYS_PROPERTY = "commitsLast30Days";
    private static final String COMMITS_OVERALL_PROPERTY = "commitsOverall";
    private static final String BRANCH_COUNT_PROPERTY = "branchCount";
    private static final String CONTRIBUTOR_COUNT_PROPERTY = "contributorCount";
    @JsonProperty(value="commitsLast24Hours")
    private final int commitsLast24Hours;
    @JsonProperty(value="commitsLast7Days")
    private final int commitsLast7Days;
    @JsonProperty(value="commitsLast30Days")
    private final int commitsLast30Days;
    @JsonProperty(value="commitsOverall")
    private final int commitsOverall;
    @JsonProperty(value="branchCount")
    private final int branchCount;
    @JsonProperty(value="contributorCount")
    private final int contributorCount;
    @JsonProperty(value="repositoriesDetails")
    private final List<RepositoryCommitOverview> repositoriesDetails = new ArrayList<RepositoryCommitOverview>();

    @JsonCreator
    public RepositoryActivitySummary(@JsonProperty(value="commitsLast24Hours") int commitsLast24Hours, @JsonProperty(value="commitsLast7Days") int commitsLast7Days, @JsonProperty(value="commitsLast30Days") int commitsLast30Days, @JsonProperty(value="commitsOverall") int commitsOverall, @JsonProperty(value="firstCommit") long firstCommit, @JsonProperty(value="mostRecentCommit") long mostRecentCommit, @JsonProperty(value="branchCount") int branchCount, @JsonProperty(value="contributorCount") int contributorCount) {
        super(firstCommit, mostRecentCommit);
        this.commitsLast24Hours = commitsLast24Hours;
        this.commitsLast7Days = commitsLast7Days;
        this.commitsLast30Days = commitsLast30Days;
        this.commitsOverall = commitsOverall;
        this.branchCount = branchCount;
        this.contributorCount = contributorCount;
    }

    public int getCommitsOverall() {
        return this.commitsOverall;
    }

    public int getCommitsLast24Hours() {
        return this.commitsLast24Hours;
    }

    public int getCommitsLast7Days() {
        return this.commitsLast7Days;
    }

    public int getCommitsLast30Days() {
        return this.commitsLast30Days;
    }

    public void addRepositoryRevisionRange(String repository, RepositoryLogEntryAggregate firstRepositoryLogEntry, RepositoryLogEntryAggregate mostRecentRepositoryLogEntry) {
        this.repositoriesDetails.add(new RepositoryCommitOverview(repository, firstRepositoryLogEntry.getRevision(), mostRecentRepositoryLogEntry.getRevision(), firstRepositoryLogEntry.getTimestamp(), mostRecentRepositoryLogEntry.getTimestamp()));
    }

    private static class RepositoryCommitOverview
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final String REPOSITORY_PROPERTY = "repository";
        private static final String FIRST_REVISION_PROPERTY = "firstRevision";
        private static final String MOST_RECENT_REVISION_PROPERTY = "mostRecentRevision";
        private static final String FIRST_REVISION_TIMESTAMP_PROPERTY = "firstRevisionTimestamp";
        private static final String MOST_RECENT_REVISION_TIMESTAMP_PROPERTY = "mostRecentRevisionTimestamp";
        @JsonProperty(value="repository")
        private final String repository;
        @JsonProperty(value="firstRevision")
        private final String firstRevision;
        @JsonProperty(value="mostRecentRevision")
        private final String mostRecentRevision;
        @JsonProperty(value="firstRevisionTimestamp")
        private final Long firstRevisionTimestamp;
        @JsonProperty(value="mostRecentRevisionTimestamp")
        private final Long mostRecentRevisionTimestamp;

        @JsonCreator
        public RepositoryCommitOverview(@JsonProperty(value="repository") String repository, @JsonProperty(value="firstRevision") String firstRevision, @JsonProperty(value="mostRecentRevision") String mostRecentRevision, @JsonProperty(value="firstRevisionTimestamp") Long firstRevisionTimestamp, @JsonProperty(value="mostRecentRevisionTimestamp") Long mostRecentRevisionTimestamp) {
            this.repository = repository;
            this.firstRevision = firstRevision;
            this.mostRecentRevision = mostRecentRevision;
            this.firstRevisionTimestamp = firstRevisionTimestamp;
            this.mostRecentRevisionTimestamp = mostRecentRevisionTimestamp;
        }
    }
}

