/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/projects/{project}/repository/debug/revision-index")
public class RepositoryRevisionDebugDumpService
extends ApiBase {
    @GET
    @Operation(summary="Prints the contents of the repository revision index.", description="Prints the contents of the repository revision index.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String printMergeRequestIndexContents() throws StorageException {
        RepositoryRevisionIndex repositoryRevisionIndex = (RepositoryRevisionIndex)this.getProjectStorageSystem().openProjectIndex(RepositoryRevisionIndex.class, null);
        StringBuilder builder = new StringBuilder();
        builder.append("Known Revisions\n").append("===============");
        RepositoryRevisionDebugDumpService.addEntriesToStringBuilder(builder, (PairList<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository>)repositoryRevisionIndex.getAllKnownRepositoryRevisions());
        builder.append("\n\nProcessed Revisions\n").append("===============");
        RepositoryRevisionDebugDumpService.addEntriesToStringBuilder(builder, (PairList<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository>)repositoryRevisionIndex.getAllProcessedRevisions());
        return builder.toString();
    }

    private static void addEntriesToStringBuilder(StringBuilder builder, PairList<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository> entries) {
        for (Pair entry : entries) {
            builder.append("\n");
            builder.append(String.format("%s > %s -> %s", ((RepositoryRevisionIndex.RevisionAndRepository)entry.getSecond()).repositoryIdentifier(), ((RepositoryRevisionIndex.RevisionAndRepository)entry.getSecond()).revision(), entry.getFirst()));
        }
    }
}

