/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository.s3;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.repository.artifact_store.s3.S3ForceFullScan;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/s3/force-full-scan")
public class S3ForceFullScanService
extends ApiBase {
    @PUT
    @RequiresProjectPermission(value={EProjectPermission.TRIGGER_COMMIT_HOOK})
    @Operation(summary="Force full scan without cache on all S3 Connectors", description="Triggers a full scan (without cache) on all S3 connections.", tags={"Connectors"})
    @ApiResponse(responseCode="404", description="If no project with the given ID was found.")
    public String scheduleS3WithFullScan(@PathParam(value="project") PublicProjectId projectId) throws StorageException {
        S3ForceFullScan s3ForceFullScan = new S3ForceFullScan(this.getIndexLayer());
        s3ForceFullScan.setS3FullScan(projectId, true);
        return "Successfully scheduled a full scan on the S3 change retrievers in project '" + String.valueOf(projectId) + "'.";
    }
}

