/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource.simulink;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.external.ExternalAnalysisPartitionIndex;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.index.simulink.tracing.DerivedTestCoverageIndex;
import com.teamscale.index.simulink.tracing.DerivedTestCoverageInfo;
import com.teamscale.index.testcoverage.LineCoverageIndex;
import com.teamscale.index.testgap.query.LineCoverageSourceQueryParameters;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/simulink/test-coverage/{uniformPath}")
public class SimulinkTestCoverageService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @Operation(summary="Get test coverage for Simulink models", description="Retrieves test coverage for a simulink model.", tags={"Test Coverage", "Simulink"}, responses={@ApiResponse(responseCode="204", description="No coverage has been uploaded yet, or the object has not been covered yet.")})
    public DerivedTestCoverageInfo getSimulinkTestCoverage(@PathParam(value="uniformPath") UniformPath uniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @BeanParam LineCoverageSourceQueryParameters coverageSources) throws StorageException {
        List<String> sourcePaths;
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        ExternalAnalysisPartitionIndex externalAnalysisPartitionIndex = this.openProjectIndex(ExternalAnalysisPartitionIndex.class, null);
        List partitions = coverageSources.getPartitions((Collection)externalAnalysisPartitionIndex.getCoveragePartitions());
        if (partitions.isEmpty()) {
            return null;
        }
        DerivedTestCoverageIndex testCoverageIndex = this.openProjectIndex(DerivedTestCoverageIndex.class, historyAccessOption);
        Optional resolvedPath = ResourceServiceUtils.resolveUniqueArchitectureElementPath((String)uniformPath.toString(), (MetricsToArchitectureMetricsMappingIndex)this.openProjectIndex(MetricsToArchitectureMetricsMappingIndex.class, historyAccessOption));
        if (resolvedPath.isEmpty()) {
            return null;
        }
        DerivedTestCoverageInfo testCoverageInfo = testCoverageIndex.getCoverageInfo((String)resolvedPath.get());
        if (testCoverageInfo == null) {
            return null;
        }
        LineCoverageIndex lineCoverageIndex = this.openProjectIndex(LineCoverageIndex.class, historyAccessOption);
        List<String> partitionsContainingCoverage = SimulinkTestCoverageService.getPartitionsContainingCoverage(partitions, lineCoverageIndex, sourcePaths = testCoverageInfo.getSourceUniformPathAsStream().distinct().collect(Collectors.toList()));
        if (partitionsContainingCoverage.isEmpty()) {
            return null;
        }
        return testCoverageInfo;
    }

    private static List<String> getPartitionsContainingCoverage(List<String> partitions, LineCoverageIndex lineCoverageIndex, List<String> sourcePaths) throws StorageException {
        ArrayList<String> partitionsContainingCoverage = new ArrayList<String>();
        for (String partition : partitions) {
            List<LineCoverageInfo> partitionCoverageInfos = lineCoverageIndex.getCoverageInfos(partition, sourcePaths).stream().filter(Objects::nonNull).toList();
            if (partitionCoverageInfos.isEmpty()) continue;
            partitionsContainingCoverage.add(partition);
        }
        return partitionsContainingCoverage;
    }
}

