/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.search;

import com.teamscale.index.comment_analysis.identifier.EStopWords;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.issues.IssueIndexBase;
import com.teamscale.index.repository.IRepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.search.ESearchTokenSourceType;
import com.teamscale.index.search.InvertedCodeSearchIndex;
import com.teamscale.index.search.SearchSource;
import com.teamscale.index.search.SearchToken;
import com.teamscale.service.commits.LogEntryResolver;
import com.teamscale.service.search.result.CodeSearchHit;
import com.teamscale.service.search.result.CommitSearchHit;
import com.teamscale.service.search.result.IssueSearchHit;
import com.teamscale.service.search.result.SearchHitBase;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

public class SearchQuery {
    private static final int MAX_DISTANCE = 200;
    private final EnumSet<EQueryType> queryTypes;
    private final List<String> lowerCaseRawTerms = new ArrayList<String>();

    private SearchQuery(EnumSet<EQueryType> queryTypes) {
        this.queryTypes = queryTypes;
    }

    public static SearchQuery parse(String query, Set<EQueryType> sources) {
        SearchQuery searchQuery = new SearchQuery(EnumSet.copyOf(sources));
        HashSet terms = CollectionUtils.asHashSet((Object[])query.trim().split("\\s+"));
        searchQuery.lowerCaseRawTerms.addAll(terms);
        return searchQuery;
    }

    public Set<SearchHitBase> performSearch(InvertedCodeSearchIndex invertedSearchIndex, SearchHitLookupIndices searchHitLookupIndices) throws StorageException {
        if (this.lowerCaseRawTerms.isEmpty()) {
            return Collections.emptySet();
        }
        List<String> termsWithoutStopWords = this.lowerCaseRawTerms.stream().filter(term -> !EStopWords.isAnyStopWord((String)term)).toList();
        List tokenLists = invertedSearchIndex.getTokensByText(termsWithoutStopWords);
        for (int i = 0; i < this.lowerCaseRawTerms.size(); ++i) {
            if (i < termsWithoutStopWords.size() && termsWithoutStopWords.get(i).equals(this.lowerCaseRawTerms.get(i))) continue;
            tokenLists.add(i, new ArrayList());
        }
        List groupedBySource = CollectionUtils.map((Collection)tokenLists, this::filterAndGroupBySource);
        HashSet matchSources = new HashSet(((ListMap)groupedBySource.get(0)).getKeys());
        for (int i = 1; i < groupedBySource.size(); ++i) {
            matchSources.retainAll((Collection<?>)((ListMap)groupedBySource.get(i)).getKeys());
        }
        HashSet<SearchHitBase> hits = new HashSet<SearchHitBase>();
        for (SearchSource source : matchSources) {
            hits.addAll(SearchQuery.createSearchHits(source, CollectionUtils.map((Collection)groupedBySource, grouped -> (List)grouped.getCollection((Object)source)), searchHitLookupIndices));
        }
        return hits;
    }

    private static List<SearchHitBase> createSearchHits(SearchSource source, List<List<SearchToken>> tokensPerTerm, SearchHitLookupIndices searchHitLookupIndices) {
        List<List<SearchToken>> bestTokensList = SearchQuery.determineClosestTokensList(tokensPerTerm);
        return CollectionUtils.map(bestTokensList, bestTokens -> SearchQuery.createSearchHit(bestTokens, source, searchHitLookupIndices));
    }

    private static SearchHitBase createSearchHit(List<SearchToken> bestTokens, SearchSource source, SearchHitLookupIndices searchHitLookupIndices) {
        PublicProjectId project = searchHitLookupIndices.projectId();
        return switch (source.getSourceType()) {
            default -> throw new MatchException(null, null);
            case ESearchTokenSourceType.CODE, ESearchTokenSourceType.PATH -> new CodeSearchHit(source, bestTokens, project, searchHitLookupIndices.tokenElementIndex());
            case ESearchTokenSourceType.ISSUE -> new IssueSearchHit(source, bestTokens, project, searchHitLookupIndices.issueIndex());
            case ESearchTokenSourceType.SPEC_ITEM -> new IssueSearchHit(source, bestTokens, project, (IssueIndexBase)searchHitLookupIndices.specItemIndices().get(TeamscaleIssueId.fromInternalId((String)source.getSourceName()).getConnectorId()));
            case ESearchTokenSourceType.COMMIT -> new CommitSearchHit(source, bestTokens, project, searchHitLookupIndices);
        };
    }

    private static List<List<SearchToken>> determineClosestTokensList(List<List<SearchToken>> searchTokensPerTerm) {
        for (List<SearchToken> tokens : searchTokensPerTerm) {
            tokens.sort(Comparator.comparingInt(SearchToken::getOffset));
        }
        ArrayList<List<SearchToken>> results = new ArrayList<List<SearchToken>>();
        for (SearchToken firstSearchToken : searchTokensPerTerm.get(0)) {
            SearchQuery.expandTermTokens(firstSearchToken, searchTokensPerTerm).ifPresent(results::add);
        }
        return results;
    }

    private static Optional<List<SearchToken>> expandTermTokens(SearchToken firstSearchToken, List<List<SearchToken>> tokensPerTerm) {
        ArrayList<SearchToken> result = new ArrayList<SearchToken>();
        result.add(firstSearchToken);
        for (int i = 1; i < tokensPerTerm.size(); ++i) {
            Optional<SearchToken> next = SearchQuery.findBestMatch((SearchToken)CollectionUtils.getLast(result), tokensPerTerm.get(i));
            if (!next.isPresent()) {
                return Optional.of(result);
            }
            result.add(next.get());
        }
        return Optional.of(result);
    }

    private static Optional<SearchToken> findBestMatch(SearchToken previous, List<SearchToken> tokens) {
        if (tokens.isEmpty()) {
            return Optional.empty();
        }
        int index = Collections.binarySearch(tokens, previous, Comparator.comparingInt(SearchToken::getOffset));
        if (index < 0) {
            index = -index - 2;
        }
        if (index + 1 < tokens.size() && tokens.get(index + 1).getOffset() - previous.getOffset() <= 200) {
            return Optional.of(tokens.get(index + 1));
        }
        if (index > 0 && index + 1 < tokens.size() && previous.getOffset() - tokens.get(index).getOffset() <= 200) {
            return Optional.of(tokens.get(index + 1));
        }
        return Optional.empty();
    }

    public static int tokenDistance(List<SearchToken> tokens) {
        int minOffset = tokens.stream().mapToInt(SearchToken::getOffset).min().getAsInt();
        int maxOffset = tokens.stream().mapToInt(SearchToken::getOffset).max().getAsInt();
        return maxOffset - minOffset;
    }

    private boolean isContainedType(ESearchTokenSourceType sourceType) {
        return switch (sourceType) {
            default -> throw new MatchException(null, null);
            case ESearchTokenSourceType.CODE, ESearchTokenSourceType.PATH -> this.queryTypes.contains((Object)EQueryType.CODE);
            case ESearchTokenSourceType.COMMIT -> this.queryTypes.contains((Object)EQueryType.COMMITS);
            case ESearchTokenSourceType.ISSUE, ESearchTokenSourceType.SPEC_ITEM -> this.queryTypes.contains((Object)EQueryType.ISSUES);
        };
    }

    private ListMap<SearchSource, SearchToken> filterAndGroupBySource(List<SearchToken> tokens) {
        ListMap grouped = new ListMap();
        for (SearchToken token : tokens) {
            if (!this.isContainedType(token.getSourceType())) continue;
            grouped.add((Object)token.getSearchSource(), (Object)token);
        }
        return grouped;
    }

    public record SearchHitLookupIndices(PublicProjectId projectId, TokenElementIndex tokenElementIndex, IssueIndex issueIndex, Map<String, SpecItemIndex> specItemIndices, RepositoryLogIndex logIndex, LogEntryResolver logEntryResolver, BiPredicate<IProjectId, IRepositoryLogEntry> privacyFilter) {
    }

    @ExportToTypeScript
    protected static enum EQueryType {
        CODE("code"),
        ISSUES("issues"),
        COMMITS("commits"),
        FILES("commits");

        private final String id;

        private EQueryType(String id) {
            this.id = id;
        }
    }
}

