/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.simulink.debug;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.simulink.signal_type.dimensions.SimulinkDimensionalityIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.simulink.model.SimulinkResolvedDimensions;

@Path(value="api/projects/{project}/simulink/debug/dimensions/{uniformPath}")
public class DebugSimulinkDimensionService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get resolved Simulink signal dimensions", description="Returns a string representation of the resolved Simulink signal dimensions.", tags={"Debugging", "Simulink"})
    public String getResolvedSimulinkSignalDimensions(@PathParam(value="uniformPath") UniformPath uniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        SimulinkDimensionalityIndex index = (SimulinkDimensionalityIndex)this.getProjectStorageSystem().openProjectIndex(SimulinkDimensionalityIndex.class, this.determineHistoryOption(commit));
        SimulinkResolvedDimensions resolvedDimensions = index.getSignalDimensions(uniformPath.toString());
        if (resolvedDimensions == null) {
            throw new NotFoundException("No resolved data types for model " + String.valueOf(uniformPath) + " found!");
        }
        return resolvedDimensions.toString();
    }
}

