/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.simulink.debug;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.dependencies.simulink.LazyModelLoader;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Optional;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.simulink.model.SimulinkModel;

@Path(value="api/projects/{project}/simulink/debug/model_workspace/{uniformPath}")
public class SimulinkModelWorkspaceDumpService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Dump model workspace information parsed from .slx file", description="Returns a string representation of the Model Workspace information we extract from the Simulink Model.", tags={"Debugging", "Simulink"})
    public String getModelWorkspaceDump(@PathParam(value="uniformPath") UniformPath uniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException, JsonSerializationException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        SimulinkModel model = this.loadModel(uniformPath.toString(), historyAccessOption);
        return JsonUtils.serializeToJSONPrettyPrinted((Object)model.modelWorkspace);
    }

    private SimulinkModel loadModel(String uniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        BinaryElementIndex index = this.openProjectIndex(BinaryElementIndex.class, historyAccessOption);
        Optional model = new LazyModelLoader(index).getModelByUniformPath(uniformPath);
        if (model.isEmpty()) {
            if (index.getContent(uniformPath) != null) {
                throw new InternalServerErrorException("Model cannot be parsed: " + uniformPath);
            }
            throw new BadRequestException("Unknown element: " + uniformPath);
        }
        return (SimulinkModel)model.get();
    }
}

