/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.prioritization;

import com.teamscale.index.testimpact.MethodId;
import com.teamscale.service.testimpact.prioritization.IPrioritizableTests;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import com.teamscale.service.testimpact.prioritization.PrioritizableTestBase;
import com.teamscale.service.testimpact.prioritization.PrioritizableTestCluster;
import com.teamscale.service.testimpact.prioritization.PrioritizeUnderBudgetCallback;
import com.teamscale.service.testimpact.prioritization.preprocessing.PreprocessingStepManager;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.jspecify.annotations.Nullable;

public interface ITestPrioritizationStrategy {
    public static final long DEFAULT_TEST_DURATION = 10000L;

    public <T extends IPrioritizableTests> List<T> orderMultipleTests(Collection<T> var1, Set<MethodId> var2, @Nullable Long var3, PrioritizeUnderBudgetCallback<T> var4) throws InterruptedException, StorageException;

    default public <T extends IPrioritizableTests> List<T> orderTests(Collection<T> relevantTests, Set<MethodId> methodsToTest, @Nullable Long maxTestSuiteRuntimeMs) throws InterruptedException, StorageException {
        return this.orderMultipleTests(relevantTests, methodsToTest, maxTestSuiteRuntimeMs, this.budgetPrioritizationCallback(methodsToTest));
    }

    default public <T extends IPrioritizableTests> PrioritizeUnderBudgetCallback<T> budgetPrioritizationCallback(Set<MethodId> methodsToTest) {
        return (test, remainingBudget) -> {
            if (test instanceof PrioritizableTestCluster) {
                PrioritizableTestCluster testCluster = (PrioritizableTestCluster)test;
                List<PrioritizableTest> prioritizedTestsInCluster = this.orderTests(testCluster.getTests(), methodsToTest, remainingBudget);
                prioritizedTestsInCluster.forEach(PrioritizableTestBase::resetCurrentAdditionallyCoveredMethods);
                testCluster.updateTestsInCluster(prioritizedTestsInCluster, methodsToTest);
            }
            return test;
        };
    }

    public void loadFurtherData(PreprocessingStepManager var1, Set<PrioritizableTest> var2) throws StorageException;
}

