/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tests;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.testimpact.TestImplementation;
import com.teamscale.index.testimpact.TestImplementationIndex;
import com.teamscale.index.tests.TestImplementationPathToExecutionPathIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/test-implementations/{testImplementation}")
public class TestImplementationsService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get test implementation", description="Returns a test implementation.", tags={"Tests"})
    public TestImplementation getTestImplementation(@PathParam(value="testImplementation") @Parameter(description="The path of the test implementation to return.") UniformPath testUniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        TestImplementationIndex testImplementationIndex = this.openProjectIndex(TestImplementationIndex.class, this.determineHistoryOption(commit));
        TestImplementation testImplementation = testImplementationIndex.getTestImplementation(testUniformPath);
        if (testImplementation == null) {
            throw new NotFoundException("Test " + String.valueOf(testUniformPath) + " does not exist!");
        }
        return testImplementation;
    }

    @GET
    @Path(value="executions")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get test executions", description="Returns the test executions for a given test implementation path.", tags={"Tests"})
    public List<String> getTestImplementationTestExecutions(@PathParam(value="testImplementation") @Parameter(description="The path of the test implementation for which to return the test executions.") UniformPath testUniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        TestImplementationPathToExecutionPathIndex testImplementationPathToExecutionPathIndex = this.openProjectIndex(TestImplementationPathToExecutionPathIndex.class, this.determineHistoryOption(commit));
        Set testExecutions = testImplementationPathToExecutionPathIndex.getExecutionPathsForImplementationPath(testUniformPath.toString());
        return new ArrayList<String>(CollectionUtils.emptyIfNull((Set)testExecutions));
    }
}

