/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tests.debug;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.testimpact.CoverageUnitChangeEntry;
import com.teamscale.index.testimpact.CoverageUnitChangeIndex;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.ImpactReason;
import com.teamscale.index.testimpact.ImpactedTestsIndex;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionWithPartition;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/tests/debug")
public class DebugTestDeletionFinderService
extends ApiBase {
    @GET
    @Path(value="deletion")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Determines when a given test execution was deleted", description="Depending on the number of commits on the branch this operation might be very expensive", tags={"Debugging"})
    public String getTestDeletion(@Parameter(required=true) @QueryParam(value="branch") String branch, @QueryParam(value="partition") String partition, @QueryParam(value="test") UniformPath testExecutionPath) throws StorageException {
        CommitDescriptorIndex commitDescriptorIndex = this.openProjectIndex(CommitDescriptorIndex.class, null);
        List commitsForBranch = commitDescriptorIndex.getCommitsForBranch(branch);
        if (commitsForBranch.isEmpty()) {
            return "No commits on branch " + branch + " found!";
        }
        int index = DebugTestDeletionFinderService.binarySearch(commitsForBranch, (FunctionWithException<ParentedCommitDescriptor, Integer, StorageException>)((FunctionWithException)commit -> {
            if (this.doesTestExist(partition, testExecutionPath, (ParentedCommitDescriptor)commit)) {
                return -1;
            }
            return 1;
        }));
        StringBuilder result = new StringBuilder();
        CCSMAssert.isTrue((index < 0 ? 1 : 0) != 0, (String)"Expected index to be negative");
        int insertionPoint = -index - 1;
        if (insertionPoint == 0) {
            result.append("The test does not seem to appear anywhere in the history.");
        } else if (insertionPoint == commitsForBranch.size()) {
            result.append("The test does still exist in " + ((ParentedCommitDescriptor)commitsForBranch.get(commitsForBranch.size() - 1)).toServiceCallFormat());
        } else {
            ParentedCommitDescriptor commitDescriptor = (ParentedCommitDescriptor)commitsForBranch.get(insertionPoint);
            this.appendTestRemovalSummary(partition, testExecutionPath, result, commitDescriptor);
        }
        return result.toString();
    }

    private boolean doesTestExist(String partition, UniformPath testExecutionPath, ParentedCommitDescriptor commit) throws StorageException {
        TestExecutionIndex testExecutionIndex = this.openProjectIndex(TestExecutionIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commit));
        TestExecutionWithPartition testExecution = testExecutionIndex.getTestExecution(partition, testExecutionPath);
        return testExecution != null;
    }

    private void appendTestRemovalSummary(String partition, UniformPath testExecutionPath, StringBuilder result, ParentedCommitDescriptor commitDescriptor) throws StorageException {
        ImpactedTestsIndex impactedTestsIndex;
        Map impactedTests;
        result.append("The test was removed in " + commitDescriptor.toServiceCallFormat() + "!\n");
        if (commitDescriptor.isMergeCommit()) {
            result.append("The commit was a merge of " + String.valueOf(commitDescriptor.getParentCommits()) + "!\n");
        }
        PartitionAndPath partitionAndPath = new PartitionAndPath(partition, testExecutionPath);
        CoverageUnitChangeIndex coverageUnitChangeIndex = this.openProjectIndex(CoverageUnitChangeIndex.class, null);
        CoverageUnitChangeEntry changeEntry = coverageUnitChangeIndex.getExistingOrEmptyEntry((CommitDescriptor)commitDescriptor);
        if (changeEntry.getDeletedTests().contains(partitionAndPath)) {
            result.append("CoverageUnitChangeIndex contains the test as deleted for that commit.\n");
        }
        if (changeEntry.getChangedTests().contains(partitionAndPath)) {
            result.append("CoverageUnitChangeIndex contains the test as changed for that commit.\n");
        }
        if ((impactedTests = (impactedTestsIndex = this.openProjectIndex(ImpactedTestsIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commitDescriptor))).getAllImpactedTestsOnPartitions(List.of(partition))).containsKey(partitionAndPath)) {
            result.append("ImpactedTestsIndex contains the test as impacted for that commit.\n");
            result.append("  " + ((ImpactReason)impactedTests.get(partitionAndPath)).toString() + "\n");
        }
    }

    @GET
    @Path(value="consistency-check")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Checks a given commit for consistency", description="Checks all related tests indices whether any of them has any outdated entries should have been deleted.", tags={"Debugging"})
    public String checkConsistency(@Parameter(required=true) @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        ImpactedTestsIndex impactedTestsIndex = this.openProjectIndex(ImpactedTestsIndex.class, historyAccessOption);
        Map impactedTests = impactedTestsIndex.getAllImpactedTests();
        TestExecutionIndex testExecutionIndex = this.openProjectIndex(TestExecutionIndex.class, historyAccessOption);
        List testExecutions = testExecutionIndex.getAllKeysDebug();
        CoverageUnitToMethodsMapIndex coverageUnitToMethodsMapIndex = this.openProjectIndex(CoverageUnitToMethodsMapIndex.class, historyAccessOption);
        List coverageUnits = coverageUnitToMethodsMapIndex.getAllTests(new HashSet(coverageUnitToMethodsMapIndex.getPartitions()));
        StringBuilder result = new StringBuilder();
        result.append("Commit has " + impactedTests.size() + " impacted tests.\n");
        boolean hasInconsistency = DebugTestDeletionFinderService.reportTestExecutionInconsistency(impactedTests, testExecutions, result);
        hasInconsistency |= DebugTestDeletionFinderService.reportImpactedTestsInconsistency(impactedTests, coverageUnits, result);
        if (!(hasInconsistency |= DebugTestDeletionFinderService.reportCoverageUnitInconsistency(testExecutions, coverageUnits, result))) {
            result.append("Didn't find any inconsistencies!");
        }
        return result.toString();
    }

    private static boolean reportTestExecutionInconsistency(Map<PartitionAndPath, ImpactReason> impactedTests, List<PartitionAndPath> testExecutions, StringBuilder result) {
        HashSet testsNotInTestExecution = CollectionUtils.differenceSet(impactedTests.keySet(), (Collection[])new Collection[]{testExecutions});
        if (testsNotInTestExecution.isEmpty()) {
            return false;
        }
        result.append(testsNotInTestExecution.size() + " of them do not exist in the TestExecutionIndex.\n");
        for (PartitionAndPath partitionAndPath : CollectionUtils.sort((Collection)testsNotInTestExecution)) {
            result.append("  - " + partitionAndPath.getPartition() + " " + partitionAndPath.getUniformPath());
        }
        return true;
    }

    private static boolean reportImpactedTestsInconsistency(Map<PartitionAndPath, ImpactReason> impactedTests, List<PartitionAndPath> coverageUnits, StringBuilder result) {
        HashSet testsNotInCoverageUnits = CollectionUtils.differenceSet(impactedTests.keySet(), (Collection[])new Collection[]{coverageUnits});
        if (testsNotInCoverageUnits.isEmpty()) {
            return false;
        }
        result.append(testsNotInCoverageUnits.size() + " of them do not exist in the CoverageUnitToMethodsMapIndex.\n");
        for (PartitionAndPath partitionAndPath : CollectionUtils.sort((Collection)testsNotInCoverageUnits)) {
            result.append("  - " + partitionAndPath.getPartition() + " " + partitionAndPath.getUniformPath());
        }
        return true;
    }

    private static boolean reportCoverageUnitInconsistency(List<PartitionAndPath> testExecutions, List<PartitionAndPath> coverageUnits, StringBuilder result) {
        HashSet coverageUnitsNotInTestExecution = CollectionUtils.differenceSet(coverageUnits, (Collection[])new Collection[]{testExecutions});
        if (coverageUnitsNotInTestExecution.isEmpty()) {
            return false;
        }
        result.append(coverageUnitsNotInTestExecution.size() + " of the tests in the CoverageUnitToMethodsMapIndex do not exist in the TestExecutionIndex.\n");
        for (PartitionAndPath partitionAndPath : CollectionUtils.sort((Collection)coverageUnitsNotInTestExecution)) {
            result.append("  - " + partitionAndPath.getPartition() + " " + partitionAndPath.getUniformPath());
        }
        return true;
    }

    private static int binarySearch(List<ParentedCommitDescriptor> commits, FunctionWithException<ParentedCommitDescriptor, Integer, StorageException> comparator) throws StorageException {
        int upper = commits.size();
        if (upper == 0) {
            return -1;
        }
        int lower = 0;
        while (lower < upper) {
            int middle = lower + upper >>> 1;
            int compare = (Integer)comparator.apply((Object)commits.get(middle));
            if (compare == 0) {
                return middle;
            }
            if (compare < 0) {
                lower = middle + 1;
                continue;
            }
            upper = middle;
        }
        return -lower - 1;
    }
}

