/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.formatting.MultipleStatementsPerLineCheck;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.preprocessor.abap.AbapPreprocessor;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Collection;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-abap-multiple-statements-per-line", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AbapMultipleStatementsPerLineCheck
extends MultipleStatementsPerLineCheck {
    @CheckOption(name="Ignored ABAP statements", description="Comma-separated, case-insensitive list of ignored ABAP statements. Statements starting with one of the ABAP keywords defined in this list will not create findings if they are used with the <b><i>Kettensatz</i></b> syntax. <br><h2>For example</h2>`DATA: lv_vehicle TYPE string, lv_car TYPE string.`<br><br>Will not create findings for `lv_vehicle` and `lv_car` if `DATA` (case-insensitive) is in the list.")
    private Set<String> ignoredAbapStatements = Set.of("write", "clear", "refresh", "free");

    @Override
    protected boolean ignoreConsecutiveStatements(ShallowEntity statement1, ShallowEntity statement2) {
        if (statement1.isEmpty()) {
            return true;
        }
        UnmodifiableList includedTokens1 = statement1.includedTokens();
        ELanguage language = TokenStreamUtils.getLanguage((Collection)includedTokens1);
        if (language == null) {
            return true;
        }
        if (language != ELanguage.ABAP) {
            LogManager.getLogger().error("AbapMultipleStatementsPerLineCheck was called for non-ABAP file " + this.context.getUniformPath());
            return false;
        }
        UnmodifiableList includedTokens2 = statement2.includedTokens();
        UnmodifiableList statement2Tokens = statement2.ownStartTokens();
        return AbapPreprocessor.isGeneratedFromAbapKettensatzStatement((UnmodifiableList)includedTokens2) && !statement2Tokens.isEmpty() && this.ignoredAbapStatements.stream().anyMatch(keyword -> ((IToken)statement2Tokens.get(0)).getText().equalsIgnoreCase((String)keyword));
    }
}

