/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.base.EntityCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-abap-optional-parameter", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class OptionalParameterCheck
extends EntityCheckBase {
    private static final Set<ETokenType> OPTIONAL_KEYWORDS = new HashSet<ETokenType>(Arrays.asList(ETokenType.OPTIONAL, ETokenType.DEFAULT));

    protected String getXPathSelectionString() {
        return "//METHOD";
    }

    protected List<ShallowEntity> filterEntities(List<ShallowEntity> entities) {
        return CollectionUtils.filter(entities, e -> e.getSubtype().equals("method declaration") && !"constructor".equals(e.getName()));
    }

    protected void processEntity(ShallowEntity entity) throws CheckException {
        List parameters = LanguageFeatureParser.ABAP.getTypeInfoForMethodParameters(entity, (List)entity.includedTokens());
        for (TypedVariable parameter : parameters) {
            if (!parameter.getModifiers().stream().map(IToken::getType).anyMatch(OPTIONAL_KEYWORDS::contains)) continue;
            this.buildFinding("%s is an optional parameter".formatted(MarkupUtils.formatAsSourceCode((String)parameter.getVariableName())), this.buildLocation().forToken(this.determineToken(parameter))).createAndStore();
        }
    }

    private IToken determineToken(TypedVariable parameter) {
        return parameter.getDeclaringEntity().includedTokens().stream().filter(token -> LanguageFeatureParser.ABAP.normalizeVariable(token.getText()).equals(parameter.getVariableName())).findFirst().orElseThrow();
    }
}

