/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-clike-no-if-zero-or-false", languages={ELanguage.JAVA, ELanguage.CS, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.OPEN_CL, ELanguage.JAVASCRIPT, ELanguage.XTEND, ELanguage.SWIFT, ELanguage.GROOVY, ELanguage.GOSU, ELanguage.KOTLIN, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ClikeNoIfZeroOrFalseCheck
extends CheckImplementationBase {
    private static final EnumSet<ETokenType> STATEMENT_SEPARATORS = EnumSet.of(ETokenType.RPAREN, ETokenType.ANDAND);

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"if".equals(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (tokens.size() <= 3) {
            return;
        }
        IToken getLiteral = (IToken)tokens.get(2);
        IToken getLastToken = (IToken)tokens.get(3);
        if (STATEMENT_SEPARATORS.contains(getLastToken.getType()) && (getLiteral.getText().equals("false") || getLiteral.getText().equals("0")) && !entity.getChildren().isEmpty()) {
            this.buildFinding("Do not use if statements to disable code", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

