/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.clike.ConditionalBlock;
import eu.cqse.check.framework.util.clike.ConditionalBlockGroupBase;
import eu.cqse.check.framework.util.clike.ConditionalBlockGroupExtractor;
import eu.cqse.check.framework.util.clike.EConditionalType;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.NonNull;

public abstract class ConditionalStatementsEqualCheckBase
extends CheckImplementationBase {
    private static final String SLOC_PROPERTY = "Number of Source Lines";

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    protected abstract boolean useCharacterEquality();

    protected abstract boolean shouldSkipBlock(ConditionalBlock var1, List<IToken> var2, int var3);

    protected abstract void prepareBlockGroupsProcessing() throws CheckException;

    protected abstract int hashBlockContent(ConditionalBlock var1) throws CheckException;

    public void execute() throws CheckException {
        ArrayList<ConditionalBlockGroupBase> blockGroups = new ArrayList<ConditionalBlockGroupBase>();
        List shallowEntities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        for (ShallowEntity entity : shallowEntities) {
            blockGroups.addAll(ConditionalBlockGroupExtractor.findCorrespondingBlockGroups((ShallowEntity)entity));
        }
        if (!blockGroups.isEmpty()) {
            this.prepareBlockGroupsProcessing();
            this.processBlockGroups(blockGroups);
        }
    }

    private void processBlockGroups(@NonNull List<ConditionalBlockGroupBase> blockGroups) throws CheckException {
        for (ConditionalBlockGroupBase blockGroup : blockGroups) {
            ListMap<Integer, ConditionalBlock> groupedBlocks = this.groupBlocksByContentHash(blockGroup);
            this.createFindingsForGroupedBlocks(groupedBlocks);
        }
    }

    private @NonNull ListMap<Integer, ConditionalBlock> groupBlocksByContentHash(@NonNull ConditionalBlockGroupBase blockGroup) throws CheckException {
        ListMap blocksByContentHash = new ListMap();
        for (ConditionalBlock block : blockGroup.getCorrespondingBlocks()) {
            if (!block.hasContent() || ConditionalStatementsEqualCheckBase.isBreakOnlyCase(block)) continue;
            blocksByContentHash.add((Object)this.hashBlockContent(block), (Object)block);
        }
        return blocksByContentHash;
    }

    private static boolean isBreakOnlyCase(@NonNull ConditionalBlock block) {
        List content = block.getContent();
        if (block.getBlockType() == EConditionalType.CASE && !content.isEmpty() && ((ShallowEntity)content.get(0)).getType() == EShallowEntityType.STATEMENT) {
            ShallowEntity entity = (ShallowEntity)content.get(0);
            if (entity.getChildren().isEmpty()) {
                return ((IToken)entity.ownStartTokens().get(0)).getType() == ETokenType.BREAK;
            }
            return (entity = (ShallowEntity)entity.getChildren().get(0)).getChildren().isEmpty() && ((IToken)entity.ownStartTokens().get(0)).getType() == ETokenType.BREAK;
        }
        return false;
    }

    private void createFindingsForGroupedBlocks(@NonNull ListMap<Integer, ConditionalBlock> blocksByContentHash) throws CheckException {
        for (Integer contentHash : blocksByContentHash.getKeys()) {
            List groupedBlock = (List)blocksByContentHash.getCollectionOrEmpty((Object)contentHash);
            if (groupedBlock.size() <= 1) continue;
            this.createFindingsForSiblingBlocks(groupedBlock);
        }
    }

    private void createFindingsForSiblingBlocks(@NonNull List<ConditionalBlock> blocks) throws CheckException {
        PairList startAndEndTokens = new PairList();
        ArrayList<FindingPropertyList> properties = new ArrayList<FindingPropertyList>();
        for (ConditionalBlock block : blocks) {
            LinkedList<IToken> blockTokens = new LinkedList<IToken>();
            int blockSloc = 0;
            for (ShallowEntity shallowEntity : block.getContent()) {
                blockTokens.addAll((Collection<IToken>)shallowEntity.includedTokens());
                blockSloc = TokenUtils.countSloc(blockTokens, new HashSet());
            }
            if (this.shouldSkipBlock(block, blockTokens, blockSloc)) continue;
            startAndEndTokens.add((Object)ConditionalStatementsEqualCheckBase.getStartToken(block), (Object)ConditionalStatementsEqualCheckBase.getEndToken(block));
            FindingPropertyList findingPropertyList = new FindingPropertyList();
            findingPropertyList.addProperty(SLOC_PROPERTY, (Object)blockSloc);
            properties.add(findingPropertyList);
        }
        this.createFindingForSiblings("Statements in Conditional Expression are equal", startAndEndTokens, properties);
    }

    private static @NonNull IToken getStartToken(@NonNull ConditionalBlock block) {
        return (IToken)((ShallowEntity)block.getContent().get(0)).includedTokens().get(0);
    }

    private static @NonNull IToken getEndToken(@NonNull ConditionalBlock block) {
        UnmodifiableList lastTokens = ((ShallowEntity)block.getContent().getLast()).includedTokens();
        return (IToken)lastTokens.getLast();
    }

    protected int hashBlockContentForUnpreprocessedLanguages(@NonNull ConditionalBlock block) {
        if (this.useCharacterEquality()) {
            StringBuilder representation = new StringBuilder();
            for (ShallowEntity statement : block.getContent()) {
                representation.append(TokenStreamTextUtils.concatTokenTexts((List)statement.includedTokens()));
            }
            return representation.toString().hashCode();
        }
        ArrayList tokenTypes = new ArrayList();
        for (ShallowEntity statement : block.getContent()) {
            statement.includedTokens().forEach(token -> tokenTypes.add(token.getType()));
        }
        return tokenTypes.hashCode();
    }
}

