/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.preprocessor.c.IncludeDirective;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.cpp.CppCheckUtils;
import java.io.File;
import java.util.List;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

@Check(id="cqse-first-include-own-header", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class FirstIncludeOwnHeaderCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        if (CppCheckUtils.isHeaderFile((String)this.context.getUniformPath())) {
            return;
        }
        List includes = TokenStreamUtils.findAllTokens((List)this.context.getTokens(ECodeViewOption.FILTERED), (ITokenMatcher)ETokenType.PREPROCESSOR_INCLUDE);
        if (includes.isEmpty()) {
            return;
        }
        String fileName = FileSystemUtils.getFilenameWithoutExtension((File)new File(this.context.getUniformPath()));
        if (FirstIncludeOwnHeaderCheck.isQuotedIncludeForFile((IToken)includes.getFirst(), fileName)) {
            return;
        }
        for (IToken include : includes.subList(1, includes.size())) {
            if (!FirstIncludeOwnHeaderCheck.isQuotedIncludeForFile(include, fileName)) continue;
            this.buildFinding("Own header file `" + fileName + "` should be included first", this.buildLocation().forToken(include)).createAndStore();
            break;
        }
    }

    private static boolean isQuotedIncludeForFile(IToken include, String fileName) {
        IncludeDirective includeDirective = IncludeDirective.createFromToken((IToken)include).orElse(null);
        if (includeDirective == null || !includeDirective.isUsingQuotes()) {
            return false;
        }
        String includedFileName = FileSystemUtils.getFilenameWithoutExtension((File)new File(includeDirective.getIncludedFilePath()));
        return includedFileName.equals(fileName);
    }
}

