/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-no-c-style-arrays", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoCStyleArraysCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.METHOD, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        if (this.containsCStyleArrays(entity)) {
            this.buildFinding("Avoid using C-style arrays", this.buildLocation().forLine(entity.getStartLine())).createAndStore();
        }
    }

    private boolean containsCStyleArrays(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        List<Integer> startingPoints = NoCStyleArraysCheck.calculateArrayDeclarationStartPoints((List<IToken>)tokens);
        return NoCStyleArraysCheck.isDeclaration(startingPoints, (List<IToken>)tokens) && !NoCStyleArraysCheck.isStringDeclaration((List<IToken>)tokens);
    }

    private static List<Integer> calculateArrayDeclarationStartPoints(List<IToken> tokens) {
        List arrayDeclarationStartingPoints = TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LBRACK});
        List attributeSpecificationStartingPoints = TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LBRACK, ETokenType.LBRACK});
        arrayDeclarationStartingPoints.removeAll(attributeSpecificationStartingPoints);
        return arrayDeclarationStartingPoints;
    }

    private static boolean isStringDeclaration(List<IToken> tokens) {
        return TokenStreamUtils.containsAll(tokens, (ETokenType[])new ETokenType[]{ETokenType.CHAR, ETokenType.STRING_LITERAL});
    }

    private static boolean isDeclaration(List<Integer> startPoints, List<IToken> tokens) {
        for (Integer index : startPoints) {
            if (index < 1) continue;
            IToken token = tokens.get(index - 1);
            return LanguageFeatureParser.CPP.isTypeToken(token);
        }
        return false;
    }
}

