/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-size-of-with-side-effects", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SizeOfWithSideEffectsCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        List offsets = TokenStreamUtils.firstTokenOfTypeSequences((List)tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.SIZEOF, ETokenType.LPAREN});
        for (Integer startOffset : offsets) {
            int endOffset = TokenStreamUtils.findMatchingClosingToken((List)tokens, (int)(startOffset + 2), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
            if (endOffset == -1) continue;
            if (TokenStreamUtils.containsAny((List)tokens, (int)(startOffset + 2), (int)endOffset, (ETokenType[])new ETokenType[]{ETokenType.PLUSPLUS, ETokenType.MINUSMINUS, ETokenType.PLUSEQ, ETokenType.MINUSEQ, ETokenType.EQ})) {
                this.buildFinding("Call to `sizeof()` contains operator with potential side effect", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
                continue;
            }
            this.findAndCreateFindingsForFunctionCalls(entity, (List<IToken>)tokens, startOffset, endOffset);
        }
    }

    private void findAndCreateFindingsForFunctionCalls(ShallowEntity entity, List<IToken> tokens, Integer startOffset, int endOffset) throws CheckException {
        List functionCalls = TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)(startOffset + 2), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN});
        for (Integer functionOffset : functionCalls) {
            if (functionOffset >= endOffset) {
                return;
            }
            this.buildFinding("Call to `sizeof()` contains function call (`" + tokens.get(functionOffset).getText() + "(...)`) with potential side effect", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
        }
    }
}

