/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ECheckTarget;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.EJavaTestFramework;
import eu.cqse.check.framework.util.IMethodCallMatcher;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.MethodCallMatchers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Check(id="java:S5863", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION}, target={ECheckTarget.TEST_CODE})
public class DontCompareWithItselfInAssertThatCheck
extends CheckImplementationBase {
    private static final JavaMethodCallMatcher JUNIT_5_ASSERT_THAT_MATCHER = JavaMethodCallMatcher.create().onTypes(EJavaTestFramework.JUNIT_5.getAssertionTypes()).withTargetMethodNames(new String[]{"assertArrayEquals", "assertEquals", "assertIterableEquals", "assertLinesMatch"}).withParameters(parameters -> parameters.size() >= 2 && DontCompareWithItselfInAssertThatCheck.parametersAreEqualAndNotRandomized((List)parameters.getFirst(), (List)parameters.get(1)));
    private static final JavaMethodCallMatcher JUNIT_4_ASSERT_THAT_MATCHER = JavaMethodCallMatcher.create().onTypes(EJavaTestFramework.JUNIT_4.getAssertionTypes()).withTargetMethodNames(new String[]{"assertArrayEquals", "assertEquals", "assertIterableEquals", "assertLinesMatch"}).withParameters(parameters -> {
        if (parameters.size() < 2) {
            return false;
        }
        if (parameters.size() == 2) {
            return DontCompareWithItselfInAssertThatCheck.parametersAreEqualAndNotRandomized((List)parameters.get(0), (List)parameters.get(1));
        }
        return DontCompareWithItselfInAssertThatCheck.parametersAreEqualAndNotRandomized((List)parameters.get(1), (List)parameters.get(2));
    });
    private static final IMethodCallMatcher ASSERT_J_AND_FEST_ASSERT_MATCHER = MethodCallMatchers.combine((JavaMethodCallMatcher[])new JavaMethodCallMatcher[]{JavaMethodCallMatcher.create().onTypes(EJavaTestFramework.ASSERT_J.getAssertionTypes()).withTargetMethodNames(new String[]{"assertThat", "assertThatObject"}).withParameterCount(1).withTag((Object)EJavaTestFramework.ASSERT_J_ASSERTION_METHODS), JavaMethodCallMatcher.create().onTypes(EJavaTestFramework.FEST_ASSERT.getAssertionTypes()).withTargetMethodNames(new String[]{"assertThat", "assertThatObject"}).withParameterCount(1).withTag(Set.of("contains", "containsExactly", "containsIgnoringCase", "containsOnly", "doesNotContain", "endsWith", "isEqualTo", "isEqualToIgnoringCase", "isSameAs", "startsWith", "hasSameHashCodeAs", "isNotEqualTo"))});
    private static final Set<String> ASSERTION_FOR_EQUALS = Set.of("isEqualTo", "assertEquals", "hasSameHashCodeAs", "isNotEqualTo");

    public void execute() throws CheckException {
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        this.findMethods((IMethodCallMatcher)JUNIT_4_ASSERT_THAT_MATCHER, typeResolver, false);
        this.findMethods((IMethodCallMatcher)JUNIT_5_ASSERT_THAT_MATCHER, typeResolver, false);
        this.findMethods(ASSERT_J_AND_FEST_ASSERT_MATCHER, typeResolver, true);
    }

    private static boolean isAssertionWithSelfComparison(JavaMethodCallMatcher.MethodCall assertionMethodCall, boolean fluentApi) {
        boolean methodWithAllowedSelfComparison = LanguageFeatureParser.JAVA.statementIsInMethodWithEqualsOrHashcodeNamePattern(assertionMethodCall.entity());
        if (!fluentApi) {
            return !methodWithAllowedSelfComparison || !DontCompareWithItselfInAssertThatCheck.isAssertionForEquals(assertionMethodCall.methodName());
        }
        Set targetMethods = Objects.requireNonNull((Set)assertionMethodCall.tag());
        List chainedCalls = assertionMethodCall.findChainedCalls();
        ArrayList<JavaMethodCallMatcher.ChainedCall> result = new ArrayList<JavaMethodCallMatcher.ChainedCall>();
        for (JavaMethodCallMatcher.ChainedCall chainedCall : chainedCalls) {
            if (targetMethods.contains(chainedCall.methodName())) {
                result.add(chainedCall);
                continue;
            }
            if (EJavaTestFramework.ASSERT_J_VALUE_NEUTRAL_METHODS.contains(chainedCall.methodName()) && result.isEmpty()) continue;
            return false;
        }
        return result.stream().anyMatch(methodNameAndParameters -> {
            List parametersOfExpectedClause;
            String assertionMethod = methodNameAndParameters.methodName();
            List parametersOfActualClause = (List)assertionMethodCall.parameters().getFirst();
            return DontCompareWithItselfInAssertThatCheck.parametersAreEqualAndNotRandomized(parametersOfActualClause, parametersOfExpectedClause = methodNameAndParameters.parameters()) && (!methodWithAllowedSelfComparison || !DontCompareWithItselfInAssertThatCheck.isAssertionForEquals(assertionMethod));
        });
    }

    private static boolean isAssertionForEquals(String assertionMethod) {
        return ASSERTION_FOR_EQUALS.contains(assertionMethod);
    }

    private void findMethods(IMethodCallMatcher assertionMatcher, JavaImportSensitiveTypeResolver typeResolver, boolean fluentApi) throws CheckException {
        for (JavaMethodCallMatcher.MethodCall methodCall : assertionMatcher.find(this.context, typeResolver)) {
            if (!DontCompareWithItselfInAssertThatCheck.isAssertionWithSelfComparison(methodCall, fluentApi)) continue;
            this.buildFinding("Replace this assertion to not have the same actual and expected expression", this.buildLocation().forToken(methodCall.token())).createAndStore();
        }
    }

    private static boolean parametersAreEqualAndNotRandomized(List<IToken> actualExpression, List<IToken> expectedExpression) {
        return TokenStreamTextUtils.tokenExpressionsAreEqual(actualExpression, expectedExpression) && actualExpression.stream().noneMatch(token -> token.getText().matches(".*[Rr]andom.*"));
    }
}

