/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-logger-with-wrong-specified-class", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class LoggerWithWrongSpecifiedClassCheck
extends CheckImplementationBase {
    private static final String GET_LOGGER = "getLogger";
    private static final String CLASS_SUFFIX = "class";

    public void execute() throws CheckException {
        List attributes = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.ATTRIBUTE);
        for (ShallowEntity attribute : attributes) {
            this.processEntity(attribute);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList includedTokens = entity.includedTokens();
        String actualClassName = entity.getParent().getName();
        for (int i = 0; i < includedTokens.size(); ++i) {
            String specifiedClassName;
            if (!GET_LOGGER.equals(((IToken)includedTokens.get(i)).getText()) || includedTokens.size() <= i + 4 || !CLASS_SUFFIX.equals(((IToken)includedTokens.get(i + 4)).getText()) || (specifiedClassName = ((IToken)includedTokens.get(i + 2)).getText()).equals(actualClassName)) continue;
            this.buildFinding("Logger should be specified with `" + actualClassName + ".class`", this.buildLocation().forEntity(entity)).createAndStore();
            return;
        }
    }
}

