/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.IShallowEntityVisitor;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-return-value-null-dereference", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ReturnValueNullDereferenceCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List methodEntities = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        IdentityHashSet methodsReturningNull = new IdentityHashSet();
        for (ShallowEntity method : methodEntities) {
            if (!ReturnValueNullDereferenceCheck.isMethodReturningNull(method)) continue;
            methodsReturningNull.add(method);
        }
        ListMap<String, ShallowEntity> reverseCallReturnRelations = ReturnValueNullDereferenceCheck.getReverseCallReturnRelations(methodEntities);
        ArrayDeque<ShallowEntity> nullReturningMethodsToBePropagated = new ArrayDeque<ShallowEntity>((Collection<ShallowEntity>)methodsReturningNull);
        while (!nullReturningMethodsToBePropagated.isEmpty()) {
            ShallowEntity method = (ShallowEntity)nullReturningMethodsToBePropagated.pollFirst();
            for (ShallowEntity newMethodReturningNull : (List)reverseCallReturnRelations.getCollectionOrElse((Object)method.getName(), Collections.emptyList())) {
                if (!methodsReturningNull.add(newMethodReturningNull)) continue;
                nullReturningMethodsToBePropagated.addLast(newMethodReturningNull);
            }
        }
        for (ShallowEntity method : methodEntities) {
            this.analyzeCallsInMethod(method, methodsReturningNull.stream().map(ShallowEntity::getName).collect(Collectors.toSet()));
        }
    }

    private static boolean isMethodReturningNull(ShallowEntity method) {
        final ArrayList returnStatements = new ArrayList();
        ShallowEntity.traverse(List.of(method), (IShallowEntityVisitor)new ShallowEntityTraversalUtils.ShallowEntityVisitorBase(){

            public boolean visit(ShallowEntity entity) {
                if (entity.getType() == EShallowEntityType.STATEMENT && "return".equals(entity.getName())) {
                    returnStatements.add(entity);
                }
                return entity.getType() != EShallowEntityType.TYPE && !ShallowParsingUtils.isLambdaMethod((ShallowEntity)entity);
            }
        });
        for (ShallowEntity returnStatement : returnStatements) {
            if (!TokenStreamUtils.containsSequence((List)returnStatement.ownStartTokens(), (ITokenMatcher[])new ITokenMatcher[]{ETokenType.RETURN, ETokenType.NULL_LITERAL, ETokenType.SEMICOLON})) continue;
            return true;
        }
        return false;
    }

    private static ListMap<String, ShallowEntity> getReverseCallReturnRelations(List<ShallowEntity> methodEntities) {
        ListMap reverseCallRelation = new ListMap();
        HashSet<String> methodNames = new HashSet<String>(CollectionUtils.map(methodEntities, ShallowEntity::getName));
        for (ShallowEntity method : methodEntities) {
            UnmodifiableList tokens = method.includedTokens();
            Iterator iterator = TokenStreamUtils.findAll((List)tokens, (ITokenMatcher)ETokenType.RETURN).iterator();
            while (iterator.hasNext()) {
                int closingParenthesisIndex;
                int expressionStartIndex = (Integer)iterator.next();
                if (!TokenStreamUtils.hasTokenTypeSequence((List)tokens, (int)expressionStartIndex, (ETokenType[])new ETokenType[]{ETokenType.RETURN, ETokenType.IDENTIFIER, ETokenType.LPAREN}) || (closingParenthesisIndex = ReturnValueNullDereferenceCheck.findCallClosingParenthesesIfContinuesWith(methodNames, ETokenType.SEMICOLON, (List<IToken>)tokens, expressionStartIndex + 1)) == -1) continue;
                reverseCallRelation.add((Object)((IToken)tokens.get(expressionStartIndex + 1)).getText(), (Object)method);
            }
        }
        return reverseCallRelation;
    }

    private void analyzeCallsInMethod(ShallowEntity method, Set<String> methodsReturningNull) {
        UnmodifiableList tokens = method.includedTokens();
        List expressionStartIndices = CollectionUtils.map((Collection)TokenStreamUtils.findAll((List)tokens, (ITokenMatcher)ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RBRACE, ETokenType.LBRACE, ETokenType.LPAREN, ETokenType.SEMICOLON, ETokenType.COMMA})), i -> i + 1);
        expressionStartIndices = CollectionUtils.filter((Collection)expressionStartIndices, arg_0 -> ReturnValueNullDereferenceCheck.lambda$analyzeCallsInMethod$1((List)tokens, arg_0));
        Iterator iterator = expressionStartIndices.iterator();
        while (iterator.hasNext()) {
            int expressionStartIndex = (Integer)iterator.next();
            int closingParenIndex = ReturnValueNullDereferenceCheck.findCallClosingParenthesesIfContinuesWith(methodsReturningNull, ETokenType.DOT, (List<IToken>)tokens, expressionStartIndex);
            if (closingParenIndex == -1) continue;
            this.buildFinding("Called method " + ((IToken)tokens.get(expressionStartIndex)).getText() + " can return null", this.buildLocation().betweenTokens((IToken)tokens.get(expressionStartIndex), (IToken)tokens.get(closingParenIndex + 1))).createAndStore();
        }
    }

    private static int findCallClosingParenthesesIfContinuesWith(Set<String> targetMethods, ETokenType continuingTokenType, List<IToken> tokens, int expressionStartIndex) {
        int closingParenIndex;
        if (TokenStreamUtils.hasTokenTypeSequence(tokens, (int)expressionStartIndex, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}) && targetMethods.contains(tokens.get(expressionStartIndex).getText()) && (closingParenIndex = TokenStreamUtils.findFirstTopLevel(tokens.subList(expressionStartIndex + 2, tokens.size()), (ITokenMatcher)ETokenType.RPAREN, Collections.singletonList(ETokenType.LPAREN), Collections.singletonList(ETokenType.RPAREN)) + expressionStartIndex + 2) != -1 && tokens.get(closingParenIndex + 1).getType() == continuingTokenType) {
            return closingParenIndex;
        }
        return -1;
    }

    private static /* synthetic */ boolean lambda$analyzeCallsInMethod$1(List tokens, Integer index) {
        return index < tokens.size();
    }
}

