/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.xml;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.conqat.lib.commons.string.StringUtils;

public class XMLPatternMatcher {
    private final String variable;
    private final List<TokenPattern> patterns = new ArrayList<TokenPattern>();
    private final List<IToken> tokens = new ArrayList<IToken>();

    XMLPatternMatcher(String variable, List<IToken> tokens) {
        this.variable = variable;
        this.tokens.addAll(tokens);
    }

    boolean hasMatch() {
        if (this.patterns.isEmpty()) {
            return false;
        }
        return new TokenPattern().alternative(this.patterns.toArray()).matchesAnywhere(this.tokens);
    }

    public void addFeaturePattern(String feature, boolean value) {
        String featureText = StringUtils.surroundWithDoubleQuotes((String)feature);
        this.patterns.addAll(this.createStringBooleanPattern("setFeature", featureText, value));
    }

    public void addFeaturePattern(String type, String attribute, boolean value) {
        this.patterns.addAll(this.createStringConstantBooleanPattern("setFeature", type, attribute, value));
    }

    public void addXIncludeAwarePattern() {
        String valueText = "true";
        TokenPattern pattern = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{this.variable})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"setXIncludeAware"})}), ETokenType.LPAREN, ETokenType.BOOLEAN_LITERAL.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{valueText})})});
        this.patterns.add(pattern);
        TokenPattern pattern2 = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{this.variable})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"setXIncludeAware"})}), ETokenType.LPAREN, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"Boolean"})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{valueText.toUpperCase(Locale.ROOT)})})});
        this.patterns.add(pattern2);
    }

    public void addPropertyPattern(String property, boolean value) {
        String propertyValue = StringUtils.surroundWithDoubleQuotes((String)property);
        this.patterns.addAll(this.createStringBooleanPattern("setProperty", propertyValue, value));
    }

    public void addPropertyPattern(String type, String attribute, boolean value) {
        this.patterns.addAll(this.createStringConstantBooleanPattern("setProperty", type, attribute, value));
    }

    public void addValidatingPattern() {
        String valueText = "true";
        TokenPattern pattern = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{this.variable})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"setValidating"})}), ETokenType.LPAREN, ETokenType.BOOLEAN_LITERAL.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{valueText})})});
        this.patterns.add(pattern);
        TokenPattern pattern2 = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{this.variable})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"setValidating"})}), ETokenType.LPAREN, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"Boolean"})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{valueText.toUpperCase(Locale.ROOT)})})});
        this.patterns.add(pattern2);
    }

    public void addAttributePattern(String attribute, String type, String field) {
        String attributeValue = StringUtils.surroundWithDoubleQuotes((String)attribute);
        String constantValue = StringUtils.surroundWithDoubleQuotes((String)"all");
        TokenPattern pattern = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{this.variable})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"setAttribute"})}), ETokenType.LPAREN, ETokenType.STRING_LITERAL.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{attributeValue})}), ETokenType.COMMA, ETokenType.STRING_LITERAL.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{constantValue})})});
        this.patterns.add(pattern);
        TokenPattern constantPattern = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{this.variable})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"setAttribute"})}), ETokenType.LPAREN, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{type})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{field})}), ETokenType.COMMA, ETokenType.STRING_LITERAL.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{constantValue})})});
        this.patterns.add(constantPattern);
    }

    private List<TokenPattern> createStringBooleanPattern(String methodName, String stringValue, boolean value) {
        String valueText = Boolean.toString(value);
        TokenPattern pattern1 = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{this.variable})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{methodName})}), ETokenType.LPAREN, ETokenType.STRING_LITERAL.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{stringValue})}), ETokenType.COMMA, ETokenType.BOOLEAN_LITERAL.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{valueText})})});
        TokenPattern pattern2 = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{this.variable})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{methodName})}), ETokenType.LPAREN, ETokenType.STRING_LITERAL.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{stringValue})}), ETokenType.COMMA, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"Boolean"})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{valueText.toUpperCase(Locale.ROOT)})})});
        return List.of(pattern1, pattern2);
    }

    private List<TokenPattern> createStringConstantBooleanPattern(String methodName, String type, String attribute, boolean value) {
        String valueText = Boolean.toString(value);
        TokenPattern pattern = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{this.variable})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{methodName})}), ETokenType.LPAREN, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{type})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{attribute})}), ETokenType.COMMA, ETokenType.BOOLEAN_LITERAL.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{valueText})})});
        TokenPattern pattern2 = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{this.variable})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{methodName})}), ETokenType.LPAREN, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{type})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{attribute})}), ETokenType.COMMA, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"Boolean"})}), ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{valueText.toUpperCase(Locale.ROOT)})})});
        return List.of(pattern, pattern2);
    }
}

