/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.javascript;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.javascript.UnacceptedTokensCheckBase;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

@Check(id="cqse-do-not-use-var-keyword", languages={ELanguage.JAVASCRIPT}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DoNotUseVarKeywordCheck
extends UnacceptedTokensCheckBase {
    @Override
    public void execute() throws CheckException {
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.META));
        for (ShallowEntity selectedEntity : selectedEntities) {
            if (selectedEntity.getType() != EShallowEntityType.STATEMENT && !"commonjs require".equals(selectedEntity.getSubtype()) && !"goog.require".equals(selectedEntity.getSubtype())) continue;
            this.processEntity(selectedEntity);
        }
    }

    @Override
    protected ITokenMatcher getUnacceptedTokenTypes() {
        return ETokenType.VAR;
    }

    @Override
    protected String getFindingMessage(IToken findingToken) {
        return "`var` keyword should be `let` or `const` instead";
    }
}

