/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.plsql;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-empty-string-assignment", languages={ELanguage.PLSQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidAssignmentToEmptyStringCheck
extends CheckImplementationBase {
    private static final String PLSQL_EMPTY_STRING_TEXT = "''";
    private static final int VARIABLE_MATCH_GROUP = 0;
    private static final int ASSIGNED_LITERAL_MATCH_GROUP = 1;
    private static final Set<ETokenType> CHAR_TYPES = Set.of(ETokenType.CHAR, ETokenType.VARCHAR, ETokenType.VARCHAR2);
    private static final TokenPattern EMPTY_STRING_ASSIGNMENT_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).optional(new Object[]{CHAR_TYPES, ETokenType.LPAREN, ETokenType.INTEGER_LITERAL, ETokenType.RPAREN}).sequence(new Object[]{ETokenType.ASSIGNMENT}).sequence(new Object[]{ETokenType.STRING_LITERAL}).group(1);

    public void execute() throws CheckException {
        List attributes = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.ATTRIBUTE);
        for (ShallowEntity attribute : attributes) {
            this.processEntity(attribute);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        List matches = EMPTY_STRING_ASSIGNMENT_PATTERN.findAll((List)tokens);
        for (TokenPatternMatch match : matches) {
            IToken assignedLiteral = (IToken)match.groupTokens(1).get(0);
            if (!AvoidAssignmentToEmptyStringCheck.isPlsqlEmptyStringLiteral(assignedLiteral)) continue;
            IToken matchedVariable = (IToken)match.groupTokens(0).get(0);
            this.buildFinding("Character-type variable `" + matchedVariable.getText() + "` assigned to empty string.", this.buildLocation().forToken(matchedVariable)).createAndStore();
        }
    }

    private static boolean isPlsqlEmptyStringLiteral(IToken token) {
        return token.getText().equals(PLSQL_EMPTY_STRING_TEXT);
    }
}

