/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.plsql;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-avoid-storing-rowid", languages={ELanguage.PLSQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidStoringRowidCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        ShallowEntity rootEntity = this.context.getRootEntity(this.getCodeViewOption());
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType(List.of(rootEntity), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"insert".equals(statement.getName())) continue;
            this.checkInsertStatement(statement);
        }
    }

    private void checkInsertStatement(ShallowEntity entity) {
        UnmodifiableList tokens = entity.includedTokens();
        if (TokenStreamUtils.containsAny((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.ROWID, ETokenType.UROWID})) {
            this.buildFinding("Avoid storing %s or %s in tables.".formatted(MarkupUtils.formatAsSourceCode((String)"ROWID"), MarkupUtils.formatAsSourceCode((String)"UROWID")), this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

