/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.plsql;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.languages.plsql.PlsqlShallowParser;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-no-variable-overloading", languages={ELanguage.PLSQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidVariableOverloadingCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        ShallowEntity rootEntity = this.context.getRootEntity(this.getCodeViewOption());
        List declareBlocks = ShallowEntityTraversalUtils.listEntitiesOfTypeNonRecursive(List.of(rootEntity), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity block : declareBlocks) {
            this.checkForVariableOverloading(block, new HashSet<String>());
        }
    }

    private void checkForVariableOverloading(ShallowEntity entity, Set<String> outerVariables) {
        List<ShallowEntity> currentVariables = AvoidVariableOverloadingCheck.extractVariableNames(entity);
        for (ShallowEntity subEntity : currentVariables) {
            if (!outerVariables.contains(subEntity.getName()) || PlsqlShallowParser.isSystemObjectKeyword((String)subEntity.getName())) continue;
            this.buildFinding("Variable %s is overloaded in a nested scope.".formatted(MarkupUtils.formatAsSourceCode((String)subEntity.getName())), this.buildLocation().forEntity(subEntity)).createAndStore();
        }
        HashSet<String> combinedVariables = new HashSet<String>(outerVariables);
        Set currentVariableNames = currentVariables.stream().map(ShallowEntity::getName).collect(Collectors.toSet());
        combinedVariables.addAll(currentVariableNames);
        UnmodifiableList nestedBlocks = entity.getChildren();
        for (ShallowEntity nestedBlock : nestedBlocks) {
            this.checkForVariableOverloading(nestedBlock, combinedVariables);
        }
    }

    private static List<ShallowEntity> extractVariableNames(ShallowEntity entity) {
        return entity.getChildrenOfType(EShallowEntityType.ATTRIBUTE).stream().filter(attribute -> attribute.getSubtype().equals("variable")).toList();
    }
}

