/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.python;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.NestingAwareTokenIterator;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.tokens.TokenStreamSplitter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-redundant-parentheses", languages={ELanguage.PYTHON}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class RedundantParenthesesCheck
extends CheckImplementationBase {
    @CheckOption(name="Ignore Parentheses around tuples", description="Redundant parentheses around tuples will be ignored")
    private boolean ignoreParenthesesAroundTuples = false;
    private static final String FINDING_MESSAGE = "Redundant parentheses";
    private static final EnumSet<ETokenType> PARENTHESES = EnumSet.of(ETokenType.LPAREN, ETokenType.RPAREN);
    private static final int CALLING_PARENTHESIS_GROUP_INDEX = 0;
    private static final EnumSet<ETokenType> VALID_IDENTIFIERS = EnumSet.of(ETokenType.IDENTIFIER, ETokenType.MATCH, ETokenType.CASE);
    private static final TokenPattern CONSTRUCTOR_OR_METHOD_CALL_PARENTHESES_PATTERN = new TokenPattern().alternative(new Object[]{VALID_IDENTIFIERS, ETokenType.RBRACK, ETokenType.RPAREN}).sequence(new Object[]{ETokenType.LPAREN}).group(0);
    private static final TokenPattern WALRUS_ASSIGNMENT_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.LPAREN}).sequence(new Object[]{VALID_IDENTIFIERS}).sequence(new Object[]{ETokenType.WALRUS});
    private static final TokenPattern MATCH_FUNCTION_CALL_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.DOT}).sequence(new Object[]{ETokenType.MATCH}).sequence(new Object[]{ETokenType.LPAREN});
    private static final EnumMap<ETokenType, ITokenMatcher> CLOSING_TYPES = new EnumMap(ETokenType.class);
    private static final ITokenMatcher UNARY_OPERATORS;

    public void execute() throws CheckException {
        List selectedEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), EnumSet.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE));
        for (ShallowEntity selectedEntity : selectedEntities) {
            this.processTokens((List<IToken>)selectedEntity.ownStartTokens());
            this.processTokens((List<IToken>)selectedEntity.ownEndTokens());
        }
    }

    private void processTokens(List<IToken> tokens) {
        Iterator iterator = TokenStreamUtils.findAll(tokens, (ITokenMatcher)ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IF, ETokenType.ELIF, ETokenType.WHILE, ETokenType.FOR, ETokenType.MATCH, ETokenType.CASE})).iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (tokens.get(index).getType() == ETokenType.MATCH && RedundantParenthesesCheck.isMatchUsedInFunctionCall(tokens, index)) continue;
            ETokenType type = tokens.get(index).getType();
            this.analyzeTokens(tokens, index, CLOSING_TYPES.get(type));
        }
        if (tokens.isEmpty() || this.ignoreParenthesesAroundTuples) {
            return;
        }
        if (TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.RETURN}) && tokens.size() > 1) {
            this.analyzeTuple(tokens.subList(1, tokens.size()));
        }
        this.extractTupleFromAssignmentAndAnalyze(tokens);
    }

    private void extractTupleFromAssignmentAndAnalyze(List<IToken> tokens) {
        if (tokens.isEmpty()) {
            return;
        }
        int equalSignTokenIndex = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.EQ);
        if (equalSignTokenIndex == -1) {
            return;
        }
        this.analyzeTuple(tokens.subList(0, equalSignTokenIndex));
        this.analyzeTuple(tokens.subList(equalSignTokenIndex + 1, tokens.size()));
    }

    private void analyzeTuple(List<IToken> tokens) {
        if (tokens.isEmpty()) {
            return;
        }
        List leftParenthesisIndices = TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.LPAREN});
        if (leftParenthesisIndices.isEmpty()) {
            return;
        }
        for (Integer leftParenthesisIndex : leftParenthesisIndices) {
            int rightParenthesisIndex;
            if (RedundantParenthesesCheck.isMethodOrConstructorCallOpeningParenthesis(tokens, leftParenthesisIndex) || (rightParenthesisIndex = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(leftParenthesisIndex + 1), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN)) == -1 || leftParenthesisIndex + 1 == rightParenthesisIndex || RedundantParenthesesCheck.hasTrailingComma(tokens, leftParenthesisIndex, rightParenthesisIndex) || RedundantParenthesesCheck.isWalrusOperator(tokens.subList(leftParenthesisIndex, tokens.size()))) continue;
            this.createFindingsForTuple(tokens, leftParenthesisIndex, rightParenthesisIndex);
        }
    }

    private static boolean isMethodOrConstructorCallOpeningParenthesis(List<IToken> tokens, int leftParenthesisIndex) {
        IToken leftParenthesis = tokens.get(leftParenthesisIndex);
        List patternMatches = CONSTRUCTOR_OR_METHOD_CALL_PARENTHESES_PATTERN.findAll(tokens);
        for (TokenPatternMatch patternMatch : patternMatches) {
            List callingParentheses = patternMatch.groupTokens(0);
            if (!callingParentheses.contains(leftParenthesis)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWalrusOperator(List<IToken> tokens) {
        return WALRUS_ASSIGNMENT_PATTERN.matchAtStartOf(tokens) != null;
    }

    private static boolean isMatchUsedInFunctionCall(List<IToken> tokens, int index) {
        return tokens.get(index).getType() == ETokenType.MATCH && index > 0 && index < tokens.size() - 1 && MATCH_FUNCTION_CALL_PATTERN.matchFully(tokens.subList(index - 1, index + 2)) != null;
    }

    private void createFindingsForTuple(List<IToken> tokens, int leftParenthesisIndex, int rightParenthesisIndex) {
        boolean areStartEndTokensParenthesis = RedundantParenthesesCheck.areStartEndTokensParenthesis(tokens, leftParenthesisIndex, rightParenthesisIndex);
        boolean toleratedCase = RedundantParenthesesCheck.isToleratedCase(tokens, leftParenthesisIndex, rightParenthesisIndex);
        if (areStartEndTokensParenthesis && !toleratedCase) {
            this.createFinding(tokens.get(leftParenthesisIndex), tokens.get(rightParenthesisIndex));
        } else {
            boolean isSurroundedByParenthesis = RedundantParenthesesCheck.isSurroundedWithParenthesis(tokens, leftParenthesisIndex, rightParenthesisIndex);
            boolean hasTupleSingleElement = RedundantParenthesesCheck.hasSingleElement(tokens.subList(leftParenthesisIndex, rightParenthesisIndex + 1));
            List commaIndices = TokenStreamUtils.getTopLevelCommaIndices(tokens, (int)(leftParenthesisIndex + 1), (int)rightParenthesisIndex);
            if (commaIndices.isEmpty() && (isSurroundedByParenthesis || hasTupleSingleElement && !toleratedCase)) {
                this.createFinding(tokens.get(leftParenthesisIndex), tokens.get(rightParenthesisIndex));
            }
        }
    }

    private static boolean isToleratedCase(List<IToken> tokens, int leftParenthesisIndex, int rightParenthesisIndex) {
        int rightParenthesisLine;
        int leftParenthesisLine = tokens.get(leftParenthesisIndex).getLineNumber();
        if (leftParenthesisLine != (rightParenthesisLine = tokens.get(rightParenthesisIndex).getLineNumber())) {
            return true;
        }
        return RedundantParenthesesCheck.isGeneratorExpression(tokens);
    }

    private static boolean isGeneratorExpression(List<IToken> tokens) {
        return TokenStreamUtils.containsAll(tokens, (ETokenType[])new ETokenType[]{ETokenType.FOR, ETokenType.IN});
    }

    private static boolean isSurroundedWithParenthesis(List<IToken> tokens, int startIndex, int endIndex) {
        int rightParenthesisIndex = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(startIndex + 2), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        return rightParenthesisIndex != -1 && rightParenthesisIndex + 1 == endIndex;
    }

    private static boolean hasSingleElement(List<IToken> tokens) {
        TokenStreamSplitter splitter = new TokenStreamSplitter(tokens);
        splitter.splitNested(ETokenType.LPAREN, ETokenType.RPAREN);
        List tokenStreams = splitter.getTokenStreams();
        if (tokenStreams.size() < 2) {
            return false;
        }
        return ((List)tokenStreams.get(1)).stream().filter(token -> !UNARY_OPERATORS.matches(token)).count() == 1L;
    }

    private static boolean areStartEndTokensParenthesis(List<IToken> tokens, int leftParenthesisIndex, int rightParenthesisIndex) {
        return leftParenthesisIndex == 0 && rightParenthesisIndex == tokens.size() - 1;
    }

    private static boolean hasTrailingComma(List<IToken> tokens, int startIndex, int endIndex) {
        List commaIndices = TokenStreamUtils.getTopLevelCommaIndices(tokens, (int)(startIndex + 1), (int)endIndex);
        return commaIndices.size() == 1 && tokens.get(endIndex - 1).getType() == ETokenType.COMMA;
    }

    private void analyzeTokens(List<IToken> tokens, int typeTokenOffset, ITokenMatcher closingTypes) {
        int endIndex = TokenStreamUtils.findFirstTopLevel(tokens, (int)(typeTokenOffset + 1), (ITokenMatcher)closingTypes, Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACK, ETokenType.LBRACE), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACK, ETokenType.RBRACE));
        if (endIndex != -1) {
            this.analyzeTokensForPossibleRedundantParenthesis(tokens.subList(typeTokenOffset + 1, endIndex));
        }
    }

    private void analyzeTokensForPossibleRedundantParenthesis(List<IToken> tokens) {
        if (tokens.isEmpty()) {
            return;
        }
        NestingAwareTokenIterator iterator = new NestingAwareTokenIterator(tokens, 0, Collections.singletonList(ETokenType.LPAREN), Collections.singletonList(ETokenType.RPAREN));
        boolean keepCounting = true;
        int nesting = 0;
        while (iterator.hasNext()) {
            ETokenType type = iterator.next().getType();
            if (keepCounting) {
                if (type == ETokenType.LPAREN) {
                    ++nesting;
                    continue;
                }
                keepCounting = false;
            }
            if (!iterator.isTopLevel() || PARENTHESES.contains(type)) continue;
            return;
        }
        IToken startToken = tokens.getFirst();
        IToken endToken = Objects.requireNonNull((IToken)CollectionUtils.getLast(tokens));
        if (!(startToken.getLineNumber() != endToken.getLineNumber() && nesting <= 1 || RedundantParenthesesCheck.isGeneratorExpression(tokens) || RedundantParenthesesCheck.isWalrusOperator(tokens))) {
            this.createFinding(startToken, endToken);
        }
    }

    private void createFinding(IToken startToken, IToken endToken) {
        this.buildFinding(FINDING_MESSAGE, this.buildLocation().betweenTokens(startToken, endToken)).createAndStore();
    }

    static {
        CLOSING_TYPES.put(ETokenType.IF, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COLON, ETokenType.ELSE, ETokenType.RBRACK, ETokenType.RBRACE}));
        CLOSING_TYPES.put(ETokenType.ELIF, (ITokenMatcher)ETokenType.COLON);
        CLOSING_TYPES.put(ETokenType.WHILE, (ITokenMatcher)ETokenType.COLON);
        CLOSING_TYPES.put(ETokenType.FOR, (ITokenMatcher)ETokenType.IN);
        CLOSING_TYPES.put(ETokenType.MATCH, (ITokenMatcher)ETokenType.COLON);
        CLOSING_TYPES.put(ETokenType.CASE, (ITokenMatcher)ETokenType.COLON);
        UNARY_OPERATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SENTINEL, ETokenType.MINUS, ETokenType.NOT});
    }
}

