/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.IStateflowElement;
import org.conqat.lib.simulink.model.stateflow.IStateflowNodeContainer;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowDeclBase;
import org.conqat.lib.simulink.model.stateflow.StateflowDeclContainerBase;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.jmaab.jc_0722", languages={ELanguage.SIMULINK})
public class SimulinkLocalDataDefinitionInParallelStatesCheck
extends CheckImplementationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String LOCAL_DATA_SCOPE = "LOCAL_DATA";
    private static final String CHART_DECOMPOSITION_TYPE = "CHART";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Declare the data so its scope is restricted to only one parallel state.");
    private static final String FINDING_MESSAGE = "The following variables are not restricted to one parallel state: {0}";

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null || model.getStateflowMachine() == null) {
            return;
        }
        for (StateflowChart chart : model.getStateflowMachine().getCharts()) {
            StateflowNode rootNode = SimulinkLocalDataDefinitionInParallelStatesCheck.createStateflowGraph(chart);
            rootNode.traverse(node -> this.checkVariablesDeclaredInNode((StateflowNode)node, chart));
        }
    }

    private void checkVariablesDeclaredInNode(StateflowNode declarationNode, StateflowChart chart) {
        IdentityHashSet offendingVariables = new IdentityHashSet();
        for (Variable variable : declarationNode.declaredVariablesByName.values()) {
            if (variable.usages.isEmpty()) continue;
            if (variable.isVariableReusedInExactlyOneParallelSubstate()) {
                offendingVariables.add(variable);
            }
            if (!variable.isDeclaredInExclusiveStateAndReusedInChildParallelState()) continue;
            offendingVariables.add(variable);
        }
        if (offendingVariables.isEmpty()) {
            return;
        }
        this.createFindingForOffendingVariables(this.buildFindingLocation(declarationNode, chart), (Set<Variable>)offendingVariables);
    }

    private void createFindingForOffendingVariables(QualifiedNameLocation findingLocation, Set<Variable> offendingVariables) {
        ArrayList offendingVariablesSorted = CollectionUtils.sort(offendingVariables);
        String offendingVariablesWithScopeTarget = offendingVariablesSorted.stream().map(variable -> MarkupUtils.formatAsSourceCode((String)(variable.name + " -> " + SimulinkLocalDataDefinitionInParallelStatesCheck.getReducedScopeTarget(variable)))).collect(Collectors.joining(", "));
        this.buildFinding(MessageFormat.format(FINDING_MESSAGE, offendingVariablesWithScopeTarget), (ElementLocation)findingLocation).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
    }

    private static String getReducedScopeTarget(Variable variable) {
        if (variable.usages.size() == 1) {
            return ((StateflowNode)variable.usages.stream().findAny().get()).toString();
        }
        return SimulinkLocalDataDefinitionInParallelStatesCheck.findInnermostCommonAncestor(variable);
    }

    private static String findInnermostCommonAncestor(Variable variable) {
        Optional<StateflowNode> innerMostCommonAncestor = variable.declarationNode.findFirst(node -> {
            Set<StateflowNode> transitiveChildren = node.getTransitiveChildren();
            if (variable.hasUsageInSubtree((StateflowNode)node) && !transitiveChildren.containsAll(variable.usages)) {
                return Optional.of(node.parent);
            }
            return Optional.empty();
        });
        if (innerMostCommonAncestor.isEmpty()) {
            LOGGER.error("No common ancestor found for " + StringUtils.concat((Iterable)variable.usages.stream().map(StateflowNode::toString).collect(Collectors.toList()), (String)", "));
            return "?";
        }
        return innerMostCommonAncestor.get().toString();
    }

    private QualifiedNameLocation buildFindingLocation(StateflowNode node, StateflowChart chart) {
        if (node.reference.equals((Object)chart)) {
            return this.buildLocation().forSimulinkBlock((SimulinkBlock)chart.getStateflowBlock());
        }
        return this.buildLocation().forStateflowNode((StateflowNodeBase)node.reference);
    }

    private static StateflowNode createStateflowGraph(StateflowChart chart) {
        HashMap<Object, StateflowNode> nodesByReference = new HashMap<Object, StateflowNode>();
        StateflowNode rootNode = new StateflowNode((StateflowDeclContainerBase<? extends IStateflowElement<?>>)chart);
        rootNode.setDeclaredVariables(SimulinkLocalDataDefinitionInParallelStatesCheck.getDeclaredVariableNames(chart));
        rootNode.setDecompositionType(CHART_DECOMPOSITION_TYPE);
        nodesByReference.put(chart, rootNode);
        List nodes = StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false);
        for (StateflowNodeBase rawNode : nodes) {
            StateflowNode parent = (StateflowNode)nodesByReference.get(SimulinkLocalDataDefinitionInParallelStatesCheck.getParentSkippingSubviewer(rawNode));
            StateflowNode stateflowNode = new StateflowNode((StateflowDeclContainerBase<? extends IStateflowElement<?>>)rawNode, parent);
            stateflowNode.setDeclaredVariables(SimulinkLocalDataDefinitionInParallelStatesCheck.getDeclaredVariableNames(rawNode));
            stateflowNode.setUsedVariables(SimulinkLocalDataDefinitionInParallelStatesCheck.getUsedVariableNames(rawNode));
            stateflowNode.setDecompositionType(SimulinkLocalDataDefinitionInParallelStatesCheck.getDecompositionType(rawNode));
            nodesByReference.put(rawNode, stateflowNode);
            parent.children.add(stateflowNode);
        }
        return rootNode;
    }

    private static IStateflowNodeContainer<?> getParentSkippingSubviewer(StateflowNodeBase rawNode) {
        IStateflowNodeContainer parent = (IStateflowNodeContainer)rawNode.getParent();
        if (parent instanceof StateflowChart && ((StateflowChart)parent).isSubviewer()) {
            return (IStateflowNodeContainer)parent.getParent();
        }
        return parent;
    }

    private static Set<String> getDeclaredVariableNames(StateflowDeclContainerBase<? extends IStateflowElement<?>> rawNode) {
        return rawNode.getData().stream().filter(data -> data.getParameter("scope").equals(LOCAL_DATA_SCOPE)).map(StateflowDeclBase::getName).collect(Collectors.toSet());
    }

    private static Set<String> getUsedVariableNames(StateflowNodeBase node) {
        StateflowState state;
        String label;
        HashSet<String> variableNames = new HashSet<String>();
        if (node instanceof StateflowState && !((StateflowState)node).isNoteBox() && !StringUtils.isEmpty((String)(label = (state = (StateflowState)node).getLabel()))) {
            variableNames.addAll(SimulinkLocalDataDefinitionInParallelStatesCheck.extractVariableNamesFromLabel(node, label));
        }
        HashSet transitions = new HashSet(node.getInTransitions());
        transitions.addAll(node.getOutTransitions());
        for (StateflowTransition transition : transitions) {
            String label2 = transition.getLabel();
            if (StringUtils.isEmpty((String)label2)) continue;
            variableNames.addAll(SimulinkLocalDataDefinitionInParallelStatesCheck.extractVariableNamesFromLabel(node, label2));
        }
        return variableNames;
    }

    private static Set<String> extractVariableNamesFromLabel(StateflowNodeBase node, String label) {
        List tokens = ScannerUtils.getTokens((String)label.replace("\\n", "\n"), (ELanguage)ELanguage.MATLAB, (String)node.getStateflowId());
        return tokens.stream().filter(token -> token.getType() == ETokenType.IDENTIFIER).map(IToken::getText).collect(Collectors.toSet());
    }

    private static String getDecompositionType(StateflowNodeBase rawNode) {
        return rawNode.getParameter("type");
    }

    private static class StateflowNode {
        private final StateflowDeclContainerBase<? extends IStateflowElement<?>> reference;
        private final StateflowNode parent;
        private String decompositionType;
        private final Set<StateflowNode> children = new IdentityHashSet();
        private Set<StateflowNode> transitiveChildren = null;
        private final Map<String, Variable> declaredVariablesByName = new HashMap<String, Variable>();

        private StateflowNode(StateflowDeclContainerBase<? extends IStateflowElement<?>> reference) {
            this.reference = reference;
            this.parent = null;
        }

        private StateflowNode(StateflowDeclContainerBase<? extends IStateflowElement<?>> reference, StateflowNode parent) {
            this.reference = reference;
            this.parent = parent;
        }

        private void setDeclaredVariables(Set<String> variableNames) {
            variableNames.stream().map(variableName -> new Variable((String)variableName, this)).forEach(variable -> this.declaredVariablesByName.put(variable.name, (Variable)variable));
        }

        private void setUsedVariables(Set<String> usedVariableNames) {
            for (String variableName : usedVariableNames) {
                Variable variable = this.getVariable(variableName);
                if (variable == null) continue;
                if (this.reference instanceof StateflowState) {
                    variable.usages.add(this);
                    continue;
                }
                variable.usages.add(this.parent);
            }
        }

        private void setDecompositionType(String decompositionType) {
            this.decompositionType = decompositionType;
        }

        protected boolean isParallelType() {
            return "AND_STATE".equals(this.decompositionType);
        }

        private Variable getVariable(String variableName) {
            if (this.declaredVariablesByName.containsKey(variableName)) {
                return this.declaredVariablesByName.get(variableName);
            }
            if (this.parent == null) {
                return null;
            }
            return this.parent.getVariable(variableName);
        }

        private Optional<StateflowNode> findFirst(Function<StateflowNode, Optional<StateflowNode>> visitor) {
            Optional<StateflowNode> result = visitor.apply(this);
            if (result.isPresent()) {
                return result;
            }
            for (StateflowNode child : this.children) {
                result = child.findFirst(visitor);
                if (!result.isPresent()) continue;
                return result;
            }
            return Optional.empty();
        }

        private void traverse(Consumer<StateflowNode> visitor) {
            this.findFirst(node -> {
                visitor.accept((StateflowNode)node);
                return Optional.empty();
            });
        }

        public String toString() {
            if (this.reference instanceof StateflowState) {
                return StateflowUtils.getStateName((StateflowState)((StateflowState)this.reference));
            }
            if (this.reference instanceof StateflowChart) {
                return ((StateflowChart)this.reference).getName();
            }
            return "Unknown reference type";
        }

        private Set<StateflowNode> getTransitiveChildren() {
            if (this.transitiveChildren == null) {
                this.transitiveChildren = new HashSet<StateflowNode>();
                this.traverse(node -> this.transitiveChildren.addAll(node.children));
            }
            return this.transitiveChildren;
        }
    }

    private static class Variable
    implements Comparable<Variable> {
        private final String name;
        private final StateflowNode declarationNode;
        private final Set<StateflowNode> usages = new IdentityHashSet();

        private Variable(String name, StateflowNode declarationNode) {
            this.name = name;
            this.declarationNode = declarationNode;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Variable other) {
            return this.name.compareTo(other.name);
        }

        private boolean isVariableReusedInExactlyOneParallelSubstate() {
            int usagesInParallelSubstates = 0;
            for (StateflowNode substate : this.declarationNode.children) {
                if (!substate.isParallelType() || !this.hasUsageInSubtree(substate) || ++usagesInParallelSubstates <= 1) continue;
                return false;
            }
            return usagesInParallelSubstates == 1;
        }

        private boolean hasUsageInSubtree(StateflowNode node) {
            if (this.usages.contains(node)) {
                return true;
            }
            return !CollectionUtils.intersectionSet(node.getTransitiveChildren(), (Collection[])new Collection[]{this.usages}).isEmpty();
        }

        private boolean isDeclaredInExclusiveStateAndReusedInChildParallelState() {
            if (!"OR_STATE".equals(this.declarationNode.decompositionType)) {
                return false;
            }
            for (StateflowNode substate : this.declarationNode.children) {
                if (!substate.isParallelType() || !this.hasUsageInSubtree(substate)) continue;
                return true;
            }
            return false;
        }
    }
}

