/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sqlscript;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-avoid-cursor", languages={ELanguage.SQLSCRIPT}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidCursorCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List attributes = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.ATTRIBUTE);
        for (ShallowEntity attribute : attributes) {
            if (!attribute.getSubtype().equals("cursor")) continue;
            this.buildFinding(this.getFindingMessage(attribute), this.buildLocation().forEntity(attribute)).createAndStore();
        }
    }

    private String getFindingMessage(ShallowEntity entity) {
        Object message = "Usage of cursor";
        UnmodifiableList tokens = entity.ownStartTokens();
        if (tokens.size() > 2) {
            String identifier = ((IToken)tokens.get(2)).getText();
            message = (String)message + " '" + identifier + "'";
        }
        return message;
    }
}

