/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia;

import com.teamscale.wia.ETextValueMode;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.WorkItemDescriberBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.wia.WorkItemCheckBase;
import eu.cqse.check.wia.parsable.rule.ParsableRule;
import eu.cqse.check.wia.parsable.rule.TypedSetRule;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

@Check(id="cqse-wia-no-empty-required-fields", languages={ELanguage.NL_REQUIREMENTS, ELanguage.NL_TESTS})
public class NoEmptyRequiredFieldsCheck
extends WorkItemCheckBase<SpecItem> {
    private static final String CHECK_NAME = "No Empty Required Fields";
    @CheckOption(name="No Empty Required Fields - Required Field Rules", description="The list of rules that specify for which *item types* and which *item fields* this check is executed.\nMultiple rules are separated by comma or new-lines.\n<p>\nA rule has the format:\n\n`<itemTypes> -> <fieldNames>`\n\n`<itemTypes>`: a `|` separated list of item types.<br>\nThis check is executed for all listed types.\nA type must be specified as full name (e.g., `Requirement`)\tor its abbreviation (e.g., `REQ`).\nThe special placeholder `ANY` can be used in place of a concrete type list to execute this check irrespective of the item types.\n\n`<fieldNames>`: a `|` separated list of item fields.<br>\nThis check is executed on all listed fields that are present in any of the item types of the same rule.\nThe special placeholder `ALL` can be used in place of a concrete field list to execute this check on all fields.\n\nHere are some example rules:\n+ `Requirement -> Description`<br>\nThe check is executed on the `Description` field of `Requirement` items.\n+ `REQ | WI -> Description | Status`<br>\nThe check is executed on the `Description` and `Status` fields of `REQ` and `WI` items.\n+ `ANY -> Description`<br>\nThe check is executed on the `Description` field of all items irrespective of their types.\n+ `REQ -> ALL`<br>\nThe check is executed on all fields of `REQ` items.\n+ `ANY -> ALL`<br>\nThe check is executed on all fields all items irrespective of their types.\n", multilineText=true)
    private Set<String> rawRequiredNoEmptyFieldRules = Collections.emptySet();
    private final HashSet<TypedSetRule<String>> parsedRequiredNoEmptyFieldRules = new HashSet();
    private static final TypedSetRule.Parser<String> PARSER = new TypedSetRule.Parser<String>().withValueParser(ParsableRule.RuleParser.TO_STRING);

    public NoEmptyRequiredFieldsCheck() {
        super(SpecItem.class);
    }

    public void initialize() throws CheckException {
        super.initialize();
        for (String rawRule : this.rawRequiredNoEmptyFieldRules) {
            this.parsedRequiredNoEmptyFieldRules.add((TypedSetRule<String>)PARSER.parse(rawRule));
        }
    }

    @Override
    protected void execute(SpecItem item) throws CheckException {
        for (TypedSetRule<String> rule : this.parsedRequiredNoEmptyFieldRules) {
            if (!rule.matches(item)) continue;
            if (rule.values.contains("ALL")) {
                for (String field : this.getDescriber((TeamscaleIssue)item).getNonTechnicalKeys((TeamscaleIssue)item)) {
                    this.checkViolation(item, field);
                }
                continue;
            }
            for (String field : rule.values) {
                this.checkViolation(item, field);
            }
        }
    }

    private void checkViolation(SpecItem item, String field) {
        WorkItemDescriberBase.IValueDescriber valueDescriber = this.getDescriber((TeamscaleIssue)item).getValueDescriber(field);
        String fieldValue = StringUtils.emptyIfNull((String)valueDescriber.getValue((TeamscaleIssue)item, ETextValueMode.WITH_HTML_TAGS_REMOVED));
        if (!fieldValue.isBlank()) {
            return;
        }
        this.buildFinding(NoEmptyRequiredFieldsCheck.buildFindingMessage(field), this.buildLocation().forWorkItem()).addFindingProperties(NoEmptyRequiredFieldsCheck.buildProperties(item, field)).createAndStore();
    }

    private static @NonNull FindingPropertyList buildProperties(SpecItem item, String violatedField) {
        FindingPropertyList properties = new FindingPropertyList();
        properties.addProperty("Item Type", (Object)item.getHumanReadableType());
        properties.addProperty("Item Field", (Object)violatedField);
        return properties;
    }

    public static String buildFindingMessage(String violatedField) {
        return "Empty, required field: '%s'".formatted(violatedField);
    }
}

