/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.abap.jco;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.system.SystemUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class JcoReflectionUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Boolean isJcoLibraryLoadedCache = null;

    public static boolean isJCoLibraryLoaded() {
        if (isJcoLibraryLoadedCache != null) {
            return isJcoLibraryLoadedCache;
        }
        try {
            Class<?> aboutClass = Class.forName("com.sap.conn.jco.rt.About");
            Method isNativeLayerAvailableMethod = aboutClass.getMethod("isNativeLayerAvailable", new Class[0]);
            isJcoLibraryLoadedCache = (Boolean)isNativeLayerAvailableMethod.invoke(null, new Object[0]);
            if (!isJcoLibraryLoadedCache.booleanValue()) {
                Method getAboutOutputAsStringMethod = aboutClass.getMethod("getAboutOutputAsString", new Class[0]);
                Object aboutOutput = (String)getAboutOutputAsStringMethod.invoke(null, new Object[0]);
                if (SystemUtils.isWindows()) {
                    aboutOutput = "Please make sure the Microsoft Visual Studio C/C++ runtime library is installed.\n" + (String)aboutOutput;
                }
                LOGGER.error("JCo JAR loaded, but native layer is missing.\n" + (String)aboutOutput);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            isJcoLibraryLoadedCache = false;
            LOGGER.error("JCo loading failed.", (Throwable)ex);
        }
        catch (ClassNotFoundException e) {
            isJcoLibraryLoadedCache = false;
        }
        return isJcoLibraryLoadedCache;
    }

    private JcoReflectionUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

