/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.base;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.markup.MarkupUtils;

public abstract class AvoidObjectComparisonWithSelfCheckBase
extends CheckImplementationBase {
    private static final Set<ETokenType> BOOLEAN_OPERATORS = EnumSet.of(ETokenType.ANDAND, ETokenType.OROR);

    @Override
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType(this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        for (int index : this.getIndicesOfComparisonExpression((List<IToken>)tokens)) {
            this.checkOperands((List<IToken>)tokens, index);
        }
    }

    private boolean isComplexExpression(List<IToken> tokens, int comparisonOperatorIndex, int secondOperandIndex) {
        EnumSet<ETokenType> expectedTokenBefore;
        EnumSet<ETokenType> expectedTokenAfter = switch (this.context.getLanguage()) {
            case ELanguage.PYTHON -> {
                expectedTokenBefore = EnumSet.of(ETokenType.LPAREN, new ETokenType[]{ETokenType.ASSERT, ETokenType.ELIF, ETokenType.IF, ETokenType.RETURN, ETokenType.WHILE});
                yield EnumSet.of(ETokenType.COLON, ETokenType.COMMA, ETokenType.RPAREN);
            }
            case ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP -> {
                expectedTokenBefore = EnumSet.of(ETokenType.LPAREN, ETokenType.LBRACK, ETokenType.RETURN, ETokenType.SEMICOLON);
                yield EnumSet.of(ETokenType.RPAREN, ETokenType.RBRACK, ETokenType.SEMICOLON);
            }
            default -> {
                expectedTokenBefore = EnumSet.of(ETokenType.LPAREN, ETokenType.RETURN, ETokenType.SEMICOLON);
                yield EnumSet.of(ETokenType.RPAREN, ETokenType.SEMICOLON);
            }
        };
        if (this.context.getLanguage() != ELanguage.PYTHON && secondOperandIndex + 1 >= tokens.size()) {
            return true;
        }
        return !AvoidObjectComparisonWithSelfCheckBase.isTokenExpectedType(tokens, comparisonOperatorIndex - 2, expectedTokenBefore) || secondOperandIndex + 1 != tokens.size() && !AvoidObjectComparisonWithSelfCheckBase.isTokenExpectedType(tokens, secondOperandIndex + 1, expectedTokenAfter);
    }

    private static boolean isTokenExpectedType(List<IToken> tokens, int tokenIndex, Set<ETokenType> expectedTokenTypes) {
        ETokenType tokenBefore = tokens.get(tokenIndex).getType();
        return expectedTokenTypes.contains(tokenBefore) || BOOLEAN_OPERATORS.contains(tokenBefore);
    }

    private void checkOperands(List<IToken> tokens, int comparisonOperatorIndex) {
        int secondOperandIndex = this.getSecondOperandIndex(comparisonOperatorIndex);
        if (comparisonOperatorIndex <= 1 || secondOperandIndex >= tokens.size()) {
            return;
        }
        if (this.context.getLanguage() == ELanguage.PYTHON && tokens.get(comparisonOperatorIndex).getType() == ETokenType.IS && tokens.get(comparisonOperatorIndex + 1).getType() == ETokenType.NOT && ++secondOperandIndex >= tokens.size()) {
            return;
        }
        IToken firstOperand = tokens.get(comparisonOperatorIndex - 1);
        IToken secondOperand = tokens.get(secondOperandIndex);
        if (firstOperand.getType() != ETokenType.IDENTIFIER || secondOperand.getType() != ETokenType.IDENTIFIER) {
            return;
        }
        if (this.isComplexExpression(tokens, comparisonOperatorIndex, secondOperandIndex)) {
            return;
        }
        if (firstOperand.getText().equals(secondOperand.getText()) && !this.isRuleException(firstOperand)) {
            this.buildFinding(MarkupUtils.formatAsSourceCode((String)firstOperand.getText()) + " is compared with itself", this.buildLocation().betweenTokens(firstOperand, secondOperand)).createAndStore();
        }
    }

    protected boolean isRuleException(IToken operand) {
        return false;
    }

    protected abstract List<Integer> getIndicesOfComparisonExpression(List<IToken> var1);

    protected abstract int getSecondOperandIndex(int var1);
}

