/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core.option;

import eu.cqse.check.framework.core.option.EToolCheckOptionType;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ToolCheckOption
implements Comparable<ToolCheckOption> {
    public static final String TSV_FILE_HEADER = "Check ID\tOption ID\tReadable Name\tDescription\tType\tDefault Value";
    public final String fullQualifiedID;
    public final String checkId;
    public final String optionId;
    private String readableOptionName;
    private String description;
    private @Nullable String defaultValue;
    public final EToolCheckOptionType type;
    public static final String ID_SEPARATOR = "#";

    public ToolCheckOption(String checkId, String optionId, String readableOptionName, String description, EToolCheckOptionType type, @Nullable String defaultValue) {
        this.checkId = checkId;
        this.optionId = optionId;
        this.fullQualifiedID = checkId + ID_SEPARATOR + optionId;
        this.readableOptionName = readableOptionName;
        this.description = description;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    @Override
    public int compareTo(@NonNull ToolCheckOption toolCheckOption) {
        return this.fullQualifiedID.compareTo(toolCheckOption.fullQualifiedID);
    }

    public void setReadableName(String readableOptionName) {
        this.readableOptionName = readableOptionName;
    }

    public String getReadableName() {
        return this.readableOptionName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDefaultValue(@Nullable String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public @Nullable String getDefaultValue() {
        return this.defaultValue;
    }
}

