/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.javascript;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.languages.base.LineBasedStatementRecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.javascript.JavaScriptShallowParser;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Stack;

class JavaScriptSimpleStatementRecognizer
extends LineBasedStatementRecognizerBase<JavaScriptShallowParser.EJavaScriptParserStates> {
    private final EShallowEntityType type;
    private final String subType;
    private final boolean typeSignaturesMayOccurInStatement;
    private final boolean inLambdaExpression;
    private boolean startsType = false;

    public JavaScriptSimpleStatementRecognizer(EShallowEntityType type, String subType, boolean typeSignaturesMayOccurInStatement, boolean inLambdaExpression) {
        this.type = type;
        this.subType = subType;
        this.typeSignaturesMayOccurInStatement = typeSignaturesMayOccurInStatement;
        this.inLambdaExpression = inLambdaExpression;
    }

    public JavaScriptSimpleStatementRecognizer(EShallowEntityType type, String subType, boolean typeSignaturesMayOccurInStatement) {
        this(type, subType, typeSignaturesMayOccurInStatement, false);
    }

    @Override
    protected JavaScriptShallowParser.EJavaScriptParserStates getSubParseState() {
        if (this.startsType) {
            this.startsType = false;
            return JavaScriptShallowParser.EJavaScriptParserStates.IN_TYPESCRIPT_TYPE;
        }
        return JavaScriptShallowParser.EJavaScriptParserStates.ANY;
    }

    @Override
    protected boolean tokenStartsSubParse(IToken token, List<IToken> tokens, int offset, Stack<ETokenType> expectedClosing, int nodeStart) {
        if (JavaScriptShallowParser.ALL_IDENTIFIERS.matches(token)) {
            return JavaScriptSimpleStatementRecognizer.startsNamedFunction(tokens, offset) || JavaScriptSimpleStatementRecognizer.startsBareLambda(tokens, offset);
        }
        if (ETokenType.FUNCTION.matches(token)) {
            boolean isFunctionCall = offset > 0 && tokens.get(offset - 1).getType() == ETokenType.DOT;
            boolean isAttributeFunction = offset <= tokens.size() - 2 && tokens.get(offset + 1).getType() == ETokenType.COLON;
            return !isFunctionCall && !isAttributeFunction;
        }
        if (JavaScriptShallowParser.PROPERTY_NAME.matches(token) && this.type == EShallowEntityType.ATTRIBUTE) {
            return JavaScriptSimpleStatementRecognizer.startsNamedFunction(tokens, offset);
        }
        if (ETokenType.LPAREN.matches(token)) {
            return this.startsParenthesisLambda(tokens, offset);
        }
        if (ETokenType.COLON.matches(token)) {
            boolean ternaryAlternative = JavaScriptSimpleStatementRecognizer.isTernaryAlternative(tokens, offset, nodeStart);
            boolean isInObject = !expectedClosing.isEmpty() && expectedClosing.peek() == ETokenType.RBRACE;
            this.startsType = !isInObject && !ternaryAlternative;
            return this.startsType;
        }
        return false;
    }

    private static boolean isTernaryAlternative(List<IToken> tokens, int colonOffset, int statementStart) {
        int openBraces = 0;
        for (int currentOffset = colonOffset - 1; currentOffset >= statementStart; --currentOffset) {
            ETokenType currentTokenType = tokens.get(currentOffset).getType();
            if (Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACE, ETokenType.LBRACK).contains(currentTokenType)) {
                --openBraces;
            } else if (Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACE, ETokenType.RBRACK).contains(currentTokenType)) {
                ++openBraces;
            }
            if (openBraces == 0 && ETokenType.QUESTION == currentTokenType && !EnumSet.of(ETokenType.DOT, ETokenType.COLON).contains(tokens.get(currentOffset + 1).getType())) {
                return true;
            }
            if (openBraces >= 0) continue;
            return false;
        }
        return false;
    }

    private boolean startsParenthesisLambda(List<IToken> tokens, int offset) {
        int closingPosition;
        if (offset > 0) {
            int ltIndex;
            ETokenType lastTokenType = tokens.get(offset - 1).getType();
            if (lastTokenType == ETokenType.IDENTIFIER) {
                return false;
            }
            if (lastTokenType == ETokenType.GT && (ltIndex = TokenStreamUtils.findMatchingOpeningToken(tokens, offset - 2, ETokenType.LT, ETokenType.GT)) > 1 && tokens.get(ltIndex - 1).getType() == ETokenType.IDENTIFIER) {
                return false;
            }
        }
        if ((closingPosition = TokenStreamUtils.findMatchingClosingToken(tokens, offset + 1, ETokenType.LPAREN, ETokenType.RPAREN)) == -1) {
            return false;
        }
        int arrowIndex = JavaScriptSimpleStatementRecognizer.getArrowIndex(tokens, offset);
        if (arrowIndex == -1 || closingPosition > arrowIndex) {
            return false;
        }
        if (closingPosition + 1 < tokens.size() && tokens.get(closingPosition + 1).getType() == ETokenType.COLON && this.typeSignaturesMayOccurInStatement) {
            return true;
        }
        return TokenStreamUtils.hasTokenTypeSequence(tokens, closingPosition + 1, ETokenType.DOUBLE_ARROW);
    }

    private static int getArrowIndex(List<IToken> tokens, int offset) {
        int firstArrowIndex = TokenStreamUtils.firstTokenMatching(tokens, offset, (ITokenMatcher)ETokenType.DOUBLE_ARROW);
        if (firstArrowIndex == -1) {
            return -1;
        }
        int lastSemicolonIndexInParams = TokenStreamUtils.lastTokenMatching(tokens.subList(offset, firstArrowIndex), (ITokenMatcher)ETokenType.SEMICOLON);
        if (lastSemicolonIndexInParams == -1 || JavaScriptSimpleStatementRecognizer.areSemicolaPartOfObjectType(tokens.subList(offset, offset + lastSemicolonIndexInParams + 1))) {
            return firstArrowIndex;
        }
        return -1;
    }

    private static boolean areSemicolaPartOfObjectType(List<IToken> tokens) {
        int countLBrace = 0;
        int countRBrace = 0;
        for (IToken token : tokens) {
            switch (token.getType()) {
                case LBRACE: {
                    ++countLBrace;
                    break;
                }
                case RBRACE: {
                    ++countRBrace;
                    break;
                }
                case SEMICOLON: {
                    if (countLBrace > countRBrace) break;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean startsBareLambda(List<IToken> tokens, int offset) {
        return offset + 2 < tokens.size() && tokens.get(offset + 1).getType() == ETokenType.DOUBLE_ARROW;
    }

    private static boolean startsNamedFunction(List<IToken> tokens, int offset) {
        return JavaScriptSimpleStatementRecognizer.startsOldStyleFunction(tokens, offset) || JavaScriptSimpleStatementRecognizer.startsNewStyleFunction(tokens, offset);
    }

    private static boolean startsNewStyleFunction(List<IToken> tokens, int offset) {
        if (offset + 1 >= tokens.size() || tokens.get(offset + 1).getType() != ETokenType.LPAREN) {
            return false;
        }
        int closingParen = TokenStreamUtils.findMatchingClosingToken(tokens, offset + 2, ETokenType.LPAREN, ETokenType.RPAREN);
        if (closingParen == -1 || closingParen + 1 >= tokens.size()) {
            return false;
        }
        return tokens.get(closingParen + 1).getType() == ETokenType.LBRACE;
    }

    private static boolean startsOldStyleFunction(List<IToken> tokens, int offset) {
        return offset + 2 < tokens.size() && tokens.get(offset + 1).getType() == ETokenType.COLON && tokens.get(offset + 2).getType() == ETokenType.FUNCTION;
    }

    @Override
    protected boolean startsNewStatement(IToken token, IToken lastToken) {
        ETokenType tokenType = token.getType();
        if (tokenType == ETokenType.RBRACE) {
            return true;
        }
        if (lastToken == null) {
            return false;
        }
        if (this.inLambdaExpression && (tokenType == ETokenType.COMMA || tokenType == ETokenType.SEMICOLON)) {
            return true;
        }
        if (lastToken.getLineNumber() == token.getLineNumber()) {
            return false;
        }
        ETokenType lastTokenType = lastToken.getType();
        if (lastTokenType == ETokenType.RETURN || lastTokenType == ETokenType.BREAK || lastTokenType == ETokenType.CONTINUE || lastTokenType == ETokenType.THROW) {
            return true;
        }
        if (tokenType == ETokenType.PLUSPLUS || tokenType == ETokenType.MINUSMINUS) {
            return true;
        }
        if (lastTokenType == ETokenType.DOT || lastTokenType == ETokenType.COMMA && this.type != EShallowEntityType.ATTRIBUTE) {
            return false;
        }
        if (lastTokenType == ETokenType.IDENTIFIER && tokenType == ETokenType.TEMPLATE_LITERAL) {
            return false;
        }
        return lastTokenType.getTokenClass() != ETokenType.ETokenClass.OPERATOR && tokenType.getTokenClass() != ETokenType.ETokenClass.OPERATOR && tokenType.getTokenClass() != ETokenType.ETokenClass.DELIMITER;
    }

    @Override
    protected EShallowEntityType getEntityType() {
        return this.type;
    }

    @Override
    protected String getEntitySubtypeName() {
        return this.subType;
    }
}

